/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.misc.ThrownJavelin;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class JavelinItem
extends SwordItem {
    public JavelinItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int ticksLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int i = this.getUseDuration(stack, entity) - ticksLeft;
            if (i >= 10 && !level.isClientSide) {
                Helpers.damageItem(stack, (LivingEntity)player, entity.getUsedItemHand());
                ThrownJavelin javelin = new ThrownJavelin(level, (LivingEntity)player, stack);
                javelin.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 1.0f);
                if (player.getAbilities().instabuild) {
                    javelin.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                level.addFreshEntity((Entity)javelin);
                level.playSound(null, (Entity)javelin, (SoundEvent)TFCSounds.JAVELIN_THROWN.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!player.getAbilities().instabuild) {
                    player.getInventory().removeItem(stack);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        if (held.getDamageValue() >= held.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)held);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)held);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tfc.tooltip.javelin.thrown_damage", (Object[])new Object[]{String.format("%.0f", Float.valueOf(this.getThrownDamage()))}).withStyle(ChatFormatting.DARK_GREEN));
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        return super.canPerformAction(stack, toolAction) && toolAction != ItemAbilities.SWORD_SWEEP;
    }

    public float getThrownDamage() {
        return 1.5f * this.getTier().getAttackDamageBonus();
    }
}

