/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.items.CreativeMiningTool;
import net.dries007.tfc.common.items.ToolItem;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ScytheItem
extends ToolItem
implements CreativeMiningTool {
    public ScytheItem(Tier tier, Item.Properties properties) {
        super(tier, TFCTags.Blocks.MINEABLE_WITH_SCYTHE, properties);
    }

    @Override
    public void mineBlockInCreative(ItemStack stack, Level level, BlockState state, BlockPos pos, Player player) {
        this.doScytheMining(stack, level, state, pos, (LivingEntity)player);
    }

    @Override
    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos origin, LivingEntity entity) {
        this.doScytheMining(stack, level, state, origin, entity);
        return super.mineBlock(stack, level, state, origin, entity);
    }

    private void doScytheMining(ItemStack stack, Level level, BlockState state, BlockPos origin, LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)origin.offset(-1, -1, -1), (BlockPos)origin.offset(1, 1, 1))) {
                BlockState stateAt = level.getBlockState(pos);
                if (pos.equals((Object)origin) || !this.isCorrectToolForDrops(stack, stateAt)) continue;
                if (!player.isCreative()) {
                    Block.dropResources((BlockState)stateAt, (Level)level, (BlockPos)pos, (BlockEntity)(stateAt.hasBlockEntity() ? level.getBlockEntity(pos) : null), (Entity)player, (ItemStack)player.getMainHandItem());
                }
                level.destroyBlock(pos, false, (Entity)player);
            }
        }
    }
}

