/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.dries007.tfc.common.entities.misc.TFCBoat;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TFCBoatItem
extends BoatItem {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final Supplier<? extends EntityType<TFCBoat>> boat;

    public TFCBoatItem(Supplier<? extends EntityType<TFCBoat>> boat, Item.Properties properties) {
        super(false, Boat.Type.OAK, properties);
        this.boat = boat;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult hitresult = TFCBoatItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 vec3 = player.getViewVector(1.0f);
        List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(vec3.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = player.getEyePosition();
            for (Entity entity : list) {
                AABB aabb = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!aabb.contains(vec31)) continue;
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        if (hitresult.getType() == HitResult.Type.BLOCK) {
            TFCBoat boat = (TFCBoat)this.boat.get().create(level);
            if (boat == null) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            boat.setPos(hitresult.getLocation().x, hitresult.getLocation().y, hitresult.getLocation().z);
            boat.setYRot(player.getYRot());
            if (!level.noCollision((Entity)boat, boat.getBoundingBox().inflate(-0.1))) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!level.isClientSide) {
                level.addFreshEntity((Entity)boat);
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, hitresult.getLocation());
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }
}

