/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.Lore;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.TFCTiers;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.plant.coral.Coral;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.food.Nutrient;
import net.dries007.tfc.common.component.glass.GlassOperation;
import net.dries007.tfc.common.component.glass.GlassOperations;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.aquatic.Fish;
import net.dries007.tfc.common.entities.misc.TFCBoat;
import net.dries007.tfc.common.fluids.FluidId;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.common.items.BlowpipeItem;
import net.dries007.tfc.common.items.EmptyPanItem;
import net.dries007.tfc.common.items.FirestarterItem;
import net.dries007.tfc.common.items.FlintAndPyriteItem;
import net.dries007.tfc.common.items.FluidContainerItem;
import net.dries007.tfc.common.items.Food;
import net.dries007.tfc.common.items.GemSawItem;
import net.dries007.tfc.common.items.GlassBlowpipeItem;
import net.dries007.tfc.common.items.GlassBottleItem;
import net.dries007.tfc.common.items.GlassworkingItem;
import net.dries007.tfc.common.items.GlowArrowItem;
import net.dries007.tfc.common.items.HideItemType;
import net.dries007.tfc.common.items.JugItem;
import net.dries007.tfc.common.items.MoldItem;
import net.dries007.tfc.common.items.PanItem;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.RottenCompostItem;
import net.dries007.tfc.common.items.TFCBoatItem;
import net.dries007.tfc.common.items.TFCMinecartItem;
import net.dries007.tfc.common.items.TorchItem;
import net.dries007.tfc.common.items.VesselItem;
import net.dries007.tfc.common.items.WindmillBladeItem;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.IdHolder;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.dries007.tfc.util.registry.RegistryMetal;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class TFCItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"tfc");
    public static final Map<Ore, ItemId> ORES = Helpers.mapOf(Ore.class, ore -> !ore.isGraded(), type -> TFCItems.register("ore/" + type.name()));
    public static final Map<Ore, Map<Ore.Grade, ItemId>> GRADED_ORES = Helpers.mapOf(Ore.class, Ore::isGraded, ore -> Helpers.mapOf(Ore.Grade.class, grade -> TFCItems.register("ore/" + grade.name() + "_" + ore.name())));
    public static final Map<Ore, ItemId> GEMS = Helpers.mapOf(Ore.class, Ore::isGem, ore -> TFCItems.register("gem/" + ore.name()));
    public static final Map<RockCategory, Map<RockCategory.ItemType, ItemId>> ROCK_TOOLS = Helpers.mapOf(RockCategory.class, category -> Helpers.mapOf(RockCategory.ItemType.class, type -> TFCItems.register("stone/" + type.name() + "/" + category.name(), () -> type.create((RockCategory)((Object)category)))));
    public static final Map<Rock, ItemId> BRICKS = Helpers.mapOf(Rock.class, type -> TFCItems.register("brick/" + type.name(), type.createItemProperties()));
    public static final Map<Metal, Map<Metal.ItemType, ItemId>> METAL_ITEMS = Helpers.mapOf(Metal.class, metal -> Helpers.mapOf(Metal.ItemType.class, type -> type.has((Metal)metal), type -> TFCItems.register("metal/" + type.name() + "/" + metal.name(), () -> type.create((RegistryMetal)metal))));
    public static final Map<Wood, ItemId> LUMBER = Helpers.mapOf(Wood.class, wood -> TFCItems.register("wood/lumber/" + wood.name()));
    public static final Map<Wood, ItemId> SUPPORTS = Helpers.mapOf(Wood.class, wood -> TFCItems.register("wood/support/" + wood.name(), () -> new StandingAndWallBlockItem((Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.VERTICAL_SUPPORT).get(), (Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.HORIZONTAL_SUPPORT).get(), new Item.Properties(), Direction.DOWN)));
    public static final Map<Wood, ItemId> BOATS = Helpers.mapOf(Wood.class, wood -> TFCItems.register("wood/boat/" + wood.name(), () -> new TFCBoatItem((Supplier<? extends EntityType<TFCBoat>>)TFCEntities.BOATS.get(wood), new Item.Properties())));
    public static final Map<Wood, ItemId> CHEST_MINECARTS = Helpers.mapOf(Wood.class, wood -> TFCItems.register("wood/chest_minecart/" + wood.name(), () -> new TFCMinecartItem(new Item.Properties(), TFCEntities.CHEST_MINECART, () -> ((Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.CHEST).get()).asItem())));
    public static final Map<Wood, ItemId> SIGNS = Helpers.mapOf(Wood.class, wood -> TFCItems.register("wood/sign/" + wood.name(), () -> new SignItem(new Item.Properties(), (Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.SIGN).get(), (Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.WALL_SIGN).get())));
    public static final Map<Wood, Map<Metal, ItemId>> HANGING_SIGNS = Helpers.mapOf(Wood.class, wood -> Helpers.mapOf(Metal.class, Metal::allParts, metal -> TFCItems.register("wood/hanging_sign/" + metal.name() + "/" + wood.name(), () -> new HangingSignItem((Block)TFCBlocks.CEILING_HANGING_SIGNS.get(wood).get(metal).get(), (Block)TFCBlocks.WALL_HANGING_SIGNS.get(wood).get(metal).get(), new Item.Properties()))));
    public static final ItemId EMPTY_JAR = TFCItems.register("empty_jar");
    public static final Map<Food, ItemId> FOOD = Helpers.mapOf(Food.class, food -> TFCItems.register("food/" + food.name(), () -> new Item(new Item.Properties())));
    public static final Map<Food, ItemId> FRUIT_PRESERVES = Helpers.mapOf(Food.class, Food::hasJam, food -> TFCItems.register("jar/" + food.name(), () -> new Item(new Item.Properties().component(Lore.TYPE, (Object)Lore.SEALED))));
    public static final Map<Food, ItemId> UNSEALED_FRUIT_PRESERVES = Helpers.mapOf(Food.class, Food::hasJam, food -> TFCItems.register("jar/" + food.name() + "_unsealed", () -> new Item(new Item.Properties().component(Lore.TYPE, (Object)Lore.UNSEALED).craftRemainder(EMPTY_JAR.asItem()))));
    public static final Map<Food, ItemId> JAM = Helpers.mapOf(Food.class, Food::hasJam, food -> TFCItems.register(food.name() + "_jam", () -> new Item(new Item.Properties())));
    public static final Map<Nutrient, ItemId> SOUPS = Helpers.mapOf(Nutrient.class, nutrient -> TFCItems.register("food/" + nutrient.name() + "_soup", () -> new Item(new Item.Properties())));
    public static final Map<Nutrient, ItemId> SALADS = Helpers.mapOf(Nutrient.class, nutrient -> TFCItems.register("food/" + nutrient.name() + "_salad", () -> new Item(new Item.Properties())));
    public static final Map<Crop, ItemId> CROP_SEEDS = Helpers.mapOf(Crop.class, crop -> TFCItems.register("seeds/" + crop.name(), () -> new ItemNameBlockItem((Block)TFCBlocks.CROPS.get(crop).get(), new Item.Properties())));
    public static final Map<Coral, ItemId> CORAL_FANS = Helpers.mapOf(Coral.class, color -> TFCItems.register("coral/" + color.toString() + "_coral_fan", () -> new StandingAndWallBlockItem((Block)TFCBlocks.CORAL.get(color).get((Object)Coral.BlockType.CORAL_FAN).get(), (Block)TFCBlocks.CORAL.get(color).get((Object)Coral.BlockType.CORAL_WALL_FAN).get(), new Item.Properties(), Direction.DOWN)));
    public static final Map<Coral, ItemId> DEAD_CORAL_FANS = Helpers.mapOf(Coral.class, color -> TFCItems.register("coral/" + color.toString() + "_dead_coral_fan", () -> new StandingAndWallBlockItem((Block)TFCBlocks.CORAL.get(color).get((Object)Coral.BlockType.DEAD_CORAL_FAN).get(), (Block)TFCBlocks.CORAL.get(color).get((Object)Coral.BlockType.DEAD_CORAL_WALL_FAN).get(), new Item.Properties(), Direction.DOWN)));
    public static final ItemId ENTISOL_MUD_BRICK = TFCItems.register("mud_brick/entisol");
    public static final ItemId ARIDISOL_MUD_BRICK = TFCItems.register("mud_brick/aridisol");
    public static final ItemId OXISOL_MUD_BRICK = TFCItems.register("mud_brick/oxisol");
    public static final ItemId FLUVISOL_MUD_BRICK = TFCItems.register("mud_brick/fluvisol");
    public static final ItemId ANDISOL_MUD_BRICK = TFCItems.register("mud_brick/andisol");
    public static final ItemId PODZOL_MUD_BRICK = TFCItems.register("mud_brick/podzol");
    public static final ItemId ALFISOL_MUD_BRICK = TFCItems.register("mud_brick/alfisol");
    public static final ItemId MOLLISOL_MUD_BRICK = TFCItems.register("mud_brick/mollisol");
    public static final ItemId ALABASTER_BRICK = TFCItems.register("alabaster_brick");
    public static final ItemId TORCH = TFCItems.register("torch", () -> new TorchItem((Block)TFCBlocks.TORCH.get(), (Block)TFCBlocks.WALL_TORCH.get(), new Item.Properties()));
    public static final ItemId DEAD_TORCH = TFCItems.register("dead_torch", () -> new StandingAndWallBlockItem((Block)TFCBlocks.DEAD_TORCH.get(), (Block)TFCBlocks.DEAD_WALL_TORCH.get(), new Item.Properties(), Direction.DOWN));
    public static final Map<HideItemType, Map<HideItemType.Size, ItemId>> HIDES = Helpers.mapOf(HideItemType.class, type -> Helpers.mapOf(HideItemType.Size.class, size -> TFCItems.register(size.name() + "_" + type.name() + "_hide", () -> new Item(new Item.Properties()))));
    public static final Map<Powder, ItemId> POWDERS = Helpers.mapOf(Powder.class, powder -> TFCItems.register("powder/" + powder.name()));
    public static final Map<Ore, ItemId> ORE_POWDERS = Helpers.mapOf(Ore.class, Ore::hasPowder, ore -> TFCItems.register("powder/" + ore.name()));
    public static final ItemId CERAMIC_BLOWPIPE = TFCItems.register("ceramic_blowpipe", () -> new BlowpipeItem(new Item.Properties()));
    public static final ItemId BLOWPIPE = TFCItems.register("blowpipe", () -> new BlowpipeItem(new Item.Properties()));
    public static final ItemId CERAMIC_BLOWPIPE_WITH_GLASS = TFCItems.register("ceramic_blowpipe_with_glass", () -> new GlassBlowpipeItem(new Item.Properties().component(TFCComponents.GLASS, (Object)GlassOperations.DEFAULT), 0.1f));
    public static final ItemId BLOWPIPE_WITH_GLASS = TFCItems.register("blowpipe_with_glass", () -> new GlassBlowpipeItem(new Item.Properties().component(TFCComponents.GLASS, (Object)GlassOperations.DEFAULT), 0.0f));
    public static final ItemId JACKS = TFCItems.register("jacks", () -> new GlassworkingItem(new Item.Properties(), (Holder<GlassOperation>)GlassOperation.PINCH));
    public static final ItemId PADDLE = TFCItems.register("paddle", () -> new GlassworkingItem(new Item.Properties(), (Holder<GlassOperation>)GlassOperation.FLATTEN));
    public static final ItemId GEM_SAW = TFCItems.register("gem_saw", () -> new GemSawItem(TFCTiers.BRONZE, new Item.Properties()));
    public static final ItemId SILICA_GLASS_BATCH = TFCItems.register("silica_glass_batch", new Item.Properties().component(Lore.TYPE, (Object)Lore.SILICA));
    public static final ItemId HEMATITIC_GLASS_BATCH = TFCItems.register("hematitic_glass_batch", new Item.Properties().component(Lore.TYPE, (Object)Lore.HEMATITIC));
    public static final ItemId OLIVINE_GLASS_BATCH = TFCItems.register("olivine_glass_batch", new Item.Properties().component(Lore.TYPE, (Object)Lore.OLIVINE));
    public static final ItemId VOLCANIC_GLASS_BATCH = TFCItems.register("volcanic_glass_batch", new Item.Properties().component(Lore.TYPE, (Object)Lore.VOLCANIC));
    public static final ItemId LAMP_GLASS = TFCItems.register("lamp_glass");
    public static final ItemId LENS = TFCItems.register("lens");
    public static final ItemId SILICA_GLASS_BOTTLE = TFCItems.register("silica_glass_bottle", () -> new GlassBottleItem(new Item.Properties().component(Lore.TYPE, (Object)Lore.SILICA), TFCConfig.SERVER.silicaGlassBottleCapacity, TFCConfig.SERVER.silicaGlassBottleBreakChance, TFCTags.Fluids.USABLE_IN_JUG));
    public static final ItemId HEMATITIC_GLASS_BOTTLE = TFCItems.register("hematitic_glass_bottle", () -> new GlassBottleItem(new Item.Properties().component(Lore.TYPE, (Object)Lore.HEMATITIC), TFCConfig.SERVER.hematiticGlassBottleCapacity, TFCConfig.SERVER.hematiticGlassBottleBreakChance, TFCTags.Fluids.USABLE_IN_JUG));
    public static final ItemId VOLCANIC_GLASS_BOTTLE = TFCItems.register("volcanic_glass_bottle", () -> new GlassBottleItem(new Item.Properties().component(Lore.TYPE, (Object)Lore.VOLCANIC), TFCConfig.SERVER.volcanicGlassBottleCapacity, TFCConfig.SERVER.volcanicGlassBottleBreakChance, TFCTags.Fluids.USABLE_IN_JUG));
    public static final ItemId OLIVINE_GLASS_BOTTLE = TFCItems.register("olivine_glass_bottle", () -> new GlassBottleItem(new Item.Properties().component(Lore.TYPE, (Object)Lore.OLIVINE), TFCConfig.SERVER.olivineGlassBottleCapacity, TFCConfig.SERVER.olivineGlassBottleBreakChance, TFCTags.Fluids.USABLE_IN_JUG));
    public static final ItemId EMPTY_JAR_WITH_LID = TFCItems.register("empty_jar_with_lid");
    public static final ItemId JAR_LID = TFCItems.register("jar_lid");
    public static final ItemId BONE_NEEDLE = TFCItems.register("bone_needle", () -> new Item(new Item.Properties().durability(64)));
    public static final ItemId BLANK_DISC = TFCItems.register("blank_disc");
    public static final ItemId BLUBBER = TFCItems.register("blubber");
    public static final ItemId BRASS_MECHANISMS = TFCItems.register("brass_mechanisms");
    public static final ItemId BURLAP_CLOTH = TFCItems.register("burlap_cloth");
    public static final ItemId COMPOST = TFCItems.register("compost");
    public static final ItemId CACTUS_WOOD = TFCItems.register("cactus_wood");
    public static final ItemId DAUB = TFCItems.register("daub");
    public static final ItemId DIRTY_JUTE_NET = TFCItems.register("dirty_jute_net");
    public static final ItemId DRIED_CACTUS_WOOD = TFCItems.register("dried_cactus_wood");
    public static final ItemId FIRE_CLAY = TFCItems.register("fire_clay");
    public static final ItemId FIRESTARTER = TFCItems.register("firestarter", () -> new FirestarterItem(new Item.Properties().durability(8)));
    public static final ItemId FLINT_AND_PYRITE = TFCItems.register("flint_and_pyrite", () -> new FlintAndPyriteItem(new Item.Properties().durability(128)));
    public static final ItemId GOAT_HORN = TFCItems.register("goat_horn");
    public static final ItemId GLOW_ARROW = TFCItems.register("glow_arrow", () -> new GlowArrowItem(new Item.Properties()));
    public static final ItemId GLUE = TFCItems.register("glue");
    public static final ItemId ALFALFA = TFCItems.register("alfalfa");
    public static final ItemId CANOLA = TFCItems.register("canola");
    public static final ItemId JUTE = TFCItems.register("jute");
    public static final ItemId JUTE_FIBER = TFCItems.register("jute_fiber");
    public static final ItemId JUTE_NET = TFCItems.register("jute_net");
    public static final ItemId KAOLIN_CLAY = TFCItems.register("kaolin_clay");
    public static final ItemId HANDSTONE = TFCItems.register("handstone", () -> new Item(new Item.Properties().durability(250)));
    public static final ItemId MORTAR = TFCItems.register("mortar");
    public static final ItemId OLIVE_PASTE = TFCItems.register("olive_paste");
    public static final ItemId CANOLA_PASTE = TFCItems.register("canola_paste");
    public static final ItemId PAPYRUS = TFCItems.register("papyrus");
    public static final ItemId PAPYRUS_STRIP = TFCItems.register("papyrus_strip");
    public static final ItemId PURE_NITROGEN = TFCItems.register("pure_nitrogen");
    public static final ItemId PURE_PHOSPHORUS = TFCItems.register("pure_phosphorus");
    public static final ItemId PURE_POTASSIUM = TFCItems.register("pure_potassium");
    public static final ItemId ROTTEN_COMPOST = TFCItems.register("rotten_compost", () -> new RottenCompostItem(new Item.Properties()));
    public static final ItemId SILK_CLOTH = TFCItems.register("silk_cloth");
    public static final ItemId SANDPAPER = TFCItems.register("sandpaper", () -> new Item(new Item.Properties().durability(40)));
    public static final ItemId SOAKED_PAPYRUS_STRIP = TFCItems.register("soaked_papyrus_strip");
    public static final ItemId SOOT = TFCItems.register("soot");
    public static final ItemId SPINDLE = TFCItems.register("spindle", () -> new Item(new Item.Properties().durability(40)));
    public static final ItemId STICK_BUNCH = TFCItems.register("stick_bunch");
    public static final ItemId STICK_BUNDLE = TFCItems.register("stick_bundle");
    public static final ItemId STRAW = TFCItems.register("straw");
    public static final ItemId TREATED_HIDE = TFCItems.register("treated_hide");
    public static final ItemId UNREFINED_PAPER = TFCItems.register("unrefined_paper");
    public static final ItemId WOODEN_BUCKET = TFCItems.register("wooden_bucket", () -> new FluidContainerItem(new Item.Properties(), TFCConfig.SERVER.woodenBucketCapacity, TFCTags.Fluids.USABLE_IN_WOODEN_BUCKET, true, TFCConfig.SERVER.woodenBucketCanPlaceSources));
    public static final ItemId WOOL = TFCItems.register("wool");
    public static final ItemId WOOL_CLOTH = TFCItems.register("wool_cloth", () -> new GlassworkingItem(new Item.Properties(), (Holder<GlassOperation>)GlassOperation.ROLL));
    public static final ItemId WOOL_YARN = TFCItems.register("wool_yarn");
    public static final ItemId WROUGHT_IRON_GRILL = TFCItems.register("wrought_iron_grill");
    public static final ItemId RAW_IRON_BLOOM = TFCItems.register("raw_iron_bloom");
    public static final ItemId REFINED_IRON_BLOOM = TFCItems.register("refined_iron_bloom");
    public static final ItemId EMPTY_PAN = TFCItems.register("pan/empty", () -> new EmptyPanItem(new Item.Properties()));
    public static final ItemId FILLED_PAN = TFCItems.register("pan/filled", () -> new PanItem(new Item.Properties().stacksTo(1)));
    public static final ItemId LATTICE_WINDMILL_BLADE = TFCItems.register("lattice_windmill_blade", () -> new WindmillBladeItem(new Item.Properties()));
    public static final ItemId RUSTIC_WINDMILL_BLADE = TFCItems.register("rustic_windmill_blade", () -> new WindmillBladeItem(new Item.Properties()));
    public static final Map<DyeColor, ItemId> WINDMILL_BLADES = Helpers.mapOf(DyeColor.class, color -> TFCItems.register("windmill_blade/" + color.getSerializedName(), () -> new WindmillBladeItem(new Item.Properties())));
    public static final Map<Fish, ItemId> FRESHWATER_FISH_EGGS = Helpers.mapOf(Fish.class, fish -> TFCItems.registerSpawnEgg(TFCEntities.FRESHWATER_FISH.get(fish)));
    public static final ItemId COD_EGG = TFCItems.registerSpawnEgg(TFCEntities.COD);
    public static final ItemId PUFFERFISH_EGG = TFCItems.registerSpawnEgg(TFCEntities.PUFFERFISH);
    public static final ItemId TROPICAL_FISH_EGG = TFCItems.registerSpawnEgg(TFCEntities.TROPICAL_FISH);
    public static final ItemId JELLYFISH_EGG = TFCItems.registerSpawnEgg(TFCEntities.JELLYFISH);
    public static final ItemId LOBSTER_EGG = TFCItems.registerSpawnEgg(TFCEntities.LOBSTER);
    public static final ItemId CRAYFISH_EGG = TFCItems.registerSpawnEgg(TFCEntities.CRAYFISH);
    public static final ItemId ISOPOD_EGG = TFCItems.registerSpawnEgg(TFCEntities.ISOPOD);
    public static final ItemId HORSESHOE_CRAB_EGG = TFCItems.registerSpawnEgg(TFCEntities.HORSESHOE_CRAB);
    public static final ItemId DOLPHIN_EGG = TFCItems.registerSpawnEgg(TFCEntities.DOLPHIN);
    public static final ItemId ORCA_EGG = TFCItems.registerSpawnEgg(TFCEntities.ORCA);
    public static final ItemId MANATEE_EGG = TFCItems.registerSpawnEgg(TFCEntities.MANATEE);
    public static final ItemId TURTLE_EGG = TFCItems.registerSpawnEgg(TFCEntities.TURTLE);
    public static final ItemId PENGUIN_EGG = TFCItems.registerSpawnEgg(TFCEntities.PENGUIN);
    public static final ItemId LEOPARD_SEAL_SPAWN_EGG = TFCItems.registerSpawnEgg(TFCEntities.LEOPARD_SEAL);
    public static final ItemId FROG_EGG = TFCItems.registerSpawnEgg(TFCEntities.FROG);
    public static final ItemId POLAR_BEAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.POLAR_BEAR);
    public static final ItemId GRIZZLY_BEAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.GRIZZLY_BEAR);
    public static final ItemId BLACK_BEAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.BLACK_BEAR);
    public static final ItemId COUGAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.COUGAR);
    public static final ItemId PANTHER_EGG = TFCItems.registerSpawnEgg(TFCEntities.PANTHER);
    public static final ItemId LION_EGG = TFCItems.registerSpawnEgg(TFCEntities.LION);
    public static final ItemId SABERTOOTH_EGG = TFCItems.registerSpawnEgg(TFCEntities.SABERTOOTH);
    public static final ItemId TIGER_EGG = TFCItems.registerSpawnEgg(TFCEntities.TIGER);
    public static final ItemId CROCODILE_EGG = TFCItems.registerSpawnEgg(TFCEntities.CROCODILE);
    public static final ItemId WOLF_EGG = TFCItems.registerSpawnEgg(TFCEntities.WOLF);
    public static final ItemId HYENA_EGG = TFCItems.registerSpawnEgg(TFCEntities.HYENA);
    public static final ItemId DIREWOLF_EGG = TFCItems.registerSpawnEgg(TFCEntities.DIREWOLF);
    public static final ItemId SQUID_EGG = TFCItems.registerSpawnEgg(TFCEntities.SQUID);
    public static final ItemId OCTOPOTEUTHIS_EGG = TFCItems.registerSpawnEgg(TFCEntities.OCTOPOTEUTHIS);
    public static final ItemId PIG_EGG = TFCItems.registerSpawnEgg(TFCEntities.PIG);
    public static final ItemId COW_EGG = TFCItems.registerSpawnEgg(TFCEntities.COW);
    public static final ItemId GOAT_EGG = TFCItems.registerSpawnEgg(TFCEntities.GOAT);
    public static final ItemId YAK_EGG = TFCItems.registerSpawnEgg(TFCEntities.YAK);
    public static final ItemId ALPACA_EGG = TFCItems.registerSpawnEgg(TFCEntities.ALPACA);
    public static final ItemId SHEEP_EGG = TFCItems.registerSpawnEgg(TFCEntities.SHEEP);
    public static final ItemId MUSK_OX_EGG = TFCItems.registerSpawnEgg(TFCEntities.MUSK_OX);
    public static final ItemId CHICKEN_EGG = TFCItems.registerSpawnEgg(TFCEntities.CHICKEN);
    public static final ItemId DUCK_EGG = TFCItems.registerSpawnEgg(TFCEntities.DUCK);
    public static final ItemId QUAIL_EGG = TFCItems.registerSpawnEgg(TFCEntities.QUAIL);
    public static final ItemId RABBIT_EGG = TFCItems.registerSpawnEgg(TFCEntities.RABBIT);
    public static final ItemId FOX_EGG = TFCItems.registerSpawnEgg(TFCEntities.FOX);
    public static final ItemId BOAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.BOAR);
    public static final ItemId WILDEBEEST_EGG = TFCItems.registerSpawnEgg(TFCEntities.WILDEBEEST);
    public static final ItemId BISON_EGG = TFCItems.registerSpawnEgg(TFCEntities.BISON);
    public static final ItemId OCELOT_EGG = TFCItems.registerSpawnEgg(TFCEntities.OCELOT);
    public static final ItemId BONGO_EGG = TFCItems.registerSpawnEgg(TFCEntities.BONGO);
    public static final ItemId CARIBOU_EGG = TFCItems.registerSpawnEgg(TFCEntities.CARIBOU);
    public static final ItemId DEER_EGG = TFCItems.registerSpawnEgg(TFCEntities.DEER);
    public static final ItemId GAZELLE_EGG = TFCItems.registerSpawnEgg(TFCEntities.GAZELLE);
    public static final ItemId MOOSE_EGG = TFCItems.registerSpawnEgg(TFCEntities.MOOSE);
    public static final ItemId GROUSE_EGG = TFCItems.registerSpawnEgg(TFCEntities.GROUSE);
    public static final ItemId PHEASANT_EGG = TFCItems.registerSpawnEgg(TFCEntities.PHEASANT);
    public static final ItemId TURKEY_EGG = TFCItems.registerSpawnEgg(TFCEntities.TURKEY);
    public static final ItemId PEAFOWL_EGG = TFCItems.registerSpawnEgg(TFCEntities.PEAFOWL);
    public static final ItemId RAT_EGG = TFCItems.registerSpawnEgg(TFCEntities.RAT);
    public static final ItemId LEMMING_EGG = TFCItems.registerSpawnEgg(TFCEntities.LEMMING);
    public static final ItemId JERBOA_EGG = TFCItems.registerSpawnEgg(TFCEntities.JERBOA);
    public static final ItemId MONGOOSE_EGG = TFCItems.registerSpawnEgg(TFCEntities.MONGOOSE);
    public static final ItemId DONKEY_EGG = TFCItems.registerSpawnEgg(TFCEntities.DONKEY);
    public static final ItemId MULE_EGG = TFCItems.registerSpawnEgg(TFCEntities.MULE);
    public static final ItemId HORSE_EGG = TFCItems.registerSpawnEgg(TFCEntities.HORSE);
    public static final ItemId CAT_EGG = TFCItems.registerSpawnEgg(TFCEntities.CAT);
    public static final ItemId DOG_EGG = TFCItems.registerSpawnEgg(TFCEntities.DOG);
    public static final ItemId PANDA_EGG = TFCItems.registerSpawnEgg(TFCEntities.PANDA);
    public static final ItemId UNFIRED_BRICK = TFCItems.register("ceramic/unfired_brick");
    public static final ItemId UNFIRED_CRUCIBLE = TFCItems.register("ceramic/unfired_crucible");
    public static final ItemId UNFIRED_FLOWER_POT = TFCItems.register("ceramic/unfired_flower_pot");
    public static final ItemId UNFIRED_PAN = TFCItems.register("ceramic/unfired_pan");
    public static final ItemId UNFIRED_BLOWPIPE = TFCItems.register("ceramic/unfired_blowpipe");
    public static final ItemId UNFIRED_BOWL = TFCItems.register("ceramic/unfired_bowl");
    public static final ItemId UNFIRED_FIRE_BRICK = TFCItems.register("ceramic/unfired_fire_brick");
    public static final ItemId FIRE_BRICK = TFCItems.register("ceramic/fire_brick");
    public static final ItemId UNFIRED_JUG = TFCItems.register("ceramic/unfired_jug");
    public static final ItemId JUG = TFCItems.register("ceramic/jug", () -> new JugItem(new Item.Properties().stacksTo(1), TFCConfig.SERVER.jugCapacity, TFCTags.Fluids.USABLE_IN_JUG));
    public static final ItemId UNFIRED_POT = TFCItems.register("ceramic/unfired_pot");
    public static final ItemId POT = TFCItems.register("ceramic/pot");
    public static final ItemId UNFIRED_SPINDLE_HEAD = TFCItems.register("ceramic/unfired_spindle_head");
    public static final ItemId SPINDLE_HEAD = TFCItems.register("ceramic/spindle_head");
    public static final ItemId UNFIRED_VESSEL = TFCItems.register("ceramic/unfired_vessel");
    public static final ItemId VESSEL = TFCItems.register("ceramic/vessel", () -> new VesselItem(new Item.Properties()));
    public static final ItemId UNFIRED_CHANNEL = TFCItems.register("ceramic/unfired_channel");
    public static final ItemId UNFIRED_MOLD_TABLE = TFCItems.register("ceramic/unfired_mold_table");
    public static final Map<DyeColor, ItemId> UNFIRED_GLAZED_VESSELS = Helpers.mapOf(DyeColor.class, color -> TFCItems.register("ceramic/" + String.valueOf(color) + "_unfired_vessel"));
    public static final Map<DyeColor, ItemId> GLAZED_VESSELS = Helpers.mapOf(DyeColor.class, color -> TFCItems.register("ceramic/" + String.valueOf(color) + "_glazed_vessel", () -> new VesselItem(new Item.Properties())));
    public static final Map<Metal.ItemType, ItemId> UNFIRED_MOLDS = Helpers.mapOf(Metal.ItemType.class, Metal.ItemType::hasMold, type -> TFCItems.register("ceramic/unfired_" + type.name() + "_mold"));
    public static final Map<Metal.ItemType, ItemId> MOLDS = Helpers.mapOf(Metal.ItemType.class, Metal.ItemType::hasMold, type -> TFCItems.register("ceramic/" + type.name() + "_mold", () -> new MoldItem((Metal.ItemType)((Object)type), new Item.Properties())));
    public static final ItemId UNFIRED_BELL_MOLD = TFCItems.register("ceramic/unfired_bell_mold");
    public static final ItemId BELL_MOLD = TFCItems.register("ceramic/bell_mold", () -> new MoldItem(TFCConfig.SERVER.moldBellCapacity, TFCTags.Fluids.USABLE_IN_BELL_MOLD, new Item.Properties()));
    public static final ItemId UNFIRED_FIRE_INGOT_MOLD = TFCItems.register("ceramic/unfired_fire_ingot_mold");
    public static final ItemId FIRE_INGOT_MOLD = TFCItems.register("ceramic/fire_ingot_mold", () -> new MoldItem(TFCConfig.SERVER.moldFireIngotCapacity, TFCTags.Fluids.USABLE_IN_INGOT_MOLD, new Item.Properties()));
    public static final ItemId UNFIRED_LARGE_VESSEL = TFCItems.register("ceramic/unfired_large_vessel");
    public static final Map<DyeColor, ItemId> UNFIRED_GLAZED_LARGE_VESSELS = Helpers.mapOf(DyeColor.class, color -> TFCItems.register("ceramic/unfired_large_vessel/" + String.valueOf(color)));
    public static final Map<FluidId, ItemId> FLUID_BUCKETS = FluidId.mapOf(fluid -> TFCItems.register("bucket/" + fluid.name(), () -> new BucketItem(fluid.fluid().get(), new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1))));
    public static final ItemId RED_STEEL_BUCKET = TFCItems.register("metal/bucket/red_steel", () -> new FluidContainerItem(new Item.Properties(), TFCConfig.SERVER.metalBucketCapacity, TFCTags.Fluids.USABLE_IN_RED_STEEL_BUCKET, true, TFCConfig.SERVER.metalBucketCanPlaceSources));
    public static final ItemId BLUE_STEEL_BUCKET = TFCItems.register("metal/bucket/blue_steel", () -> new FluidContainerItem(new Item.Properties(), TFCConfig.SERVER.metalBucketCapacity, TFCTags.Fluids.USABLE_IN_BLUE_STEEL_BUCKET, true, TFCConfig.SERVER.metalBucketCanPlaceSources));
    public static final ItemId COD_BUCKET = TFCItems.register("bucket/cod", () -> new MobBucketItem((EntityType)TFCEntities.COD.get(), (Fluid)TFCFluids.SALT_WATER.getSource(), SoundEvents.BUCKET_EMPTY_FISH, new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
    public static final ItemId PUFFERFISH_BUCKET = TFCItems.register("bucket/pufferfish", () -> new MobBucketItem((EntityType)TFCEntities.PUFFERFISH.get(), (Fluid)TFCFluids.SALT_WATER.getSource(), SoundEvents.BUCKET_EMPTY_FISH, new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
    public static final ItemId JELLYFISH_BUCKET = TFCItems.register("bucket/jellyfish", () -> new MobBucketItem((EntityType)TFCEntities.JELLYFISH.get(), (Fluid)TFCFluids.SALT_WATER.getSource(), SoundEvents.BUCKET_EMPTY_FISH, new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
    public static final ItemId TROPICAL_FISH_BUCKET = TFCItems.register("bucket/tropical_fish", () -> new MobBucketItem((EntityType)TFCEntities.TROPICAL_FISH.get(), (Fluid)TFCFluids.SALT_WATER.getSource(), SoundEvents.BUCKET_EMPTY_FISH, new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
    public static final Map<Fish, ItemId> FRESHWATER_FISH_BUCKETS = Helpers.mapOf(Fish.class, fish -> TFCItems.register("bucket/" + fish.getSerializedName(), () -> new MobBucketItem((EntityType)TFCEntities.FRESHWATER_FISH.get(fish).get(), (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1))));

    private static <T extends Mob> ItemId registerSpawnEgg(IdHolder<EntityType<T>> entity) {
        return TFCItems.register("spawn_egg/" + entity.getId().getPath(), () -> new DeferredSpawnEggItem(entity.holder(), 0xFFFFFF, 0xFFFFFF, new Item.Properties()));
    }

    private static ItemId register(String name) {
        return TFCItems.register(name, () -> new Item(new Item.Properties()));
    }

    private static ItemId register(String name, Item.Properties properties) {
        return new ItemId((DeferredHolder<Item, Item>)ITEMS.register(name.toLowerCase(Locale.ROOT), () -> new Item(properties)));
    }

    private static ItemId register(String name, Supplier<Item> item) {
        return new ItemId((DeferredHolder<Item, Item>)ITEMS.register(name.toLowerCase(Locale.ROOT), item));
    }

    public record ItemId(DeferredHolder<Item, Item> holder) implements RegistryHolder<Item, Item>,
    ItemLike
    {
        public Item asItem() {
            return (Item)this.get();
        }
    }
}

