/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.player;

import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodData;
import net.dries007.tfc.common.component.food.IFood;
import net.dries007.tfc.common.component.food.INutritionData;
import net.dries007.tfc.common.player.ChiselMode;
import net.dries007.tfc.common.player.PlayerBridge;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.network.PlayerInfoPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface IPlayerInfo {
    public static final float DEFAULT_AVERAGE_NUTRITION = 0.4f;

    public static IPlayerInfo get(Player player) {
        return ((PlayerBridge)player).tfc$getPlayerInfo();
    }

    public static void copyOnDeath(Player oldPlayer, Player newPlayer) {
        IPlayerInfo oldInfo = IPlayerInfo.get(oldPlayer);
        IPlayerInfo newInfo = IPlayerInfo.get(newPlayer);
        newInfo.copyOnDeath(oldInfo);
    }

    public void onDrink();

    public boolean canDrink();

    public ChiselMode chiselMode();

    public void cycleChiselMode();

    public float getIntoxication();

    public void addIntoxication(long var1);

    public float getThirst();

    default public void addThirst(float value) {
        this.setThirst(this.getThirst() + value);
    }

    public void setThirst(float var1);

    public float getThirstContributionFromTemperature();

    public INutritionData nutrition();

    default public float getHealthModifier() {
        float averageNutrition = this.nutrition().getAverageNutrition();
        return averageNutrition < 0.4f ? Mth.map((float)averageNutrition, (float)0.0f, (float)0.4f, (float)TFCConfig.SERVER.nutritionMinimumHealthModifier.get().floatValue(), (float)TFCConfig.SERVER.nutritionDefaultHealthModifier.get().floatValue()) : Mth.clampedMap((float)averageNutrition, (float)0.4f, (float)0.95f, (float)TFCConfig.SERVER.nutritionDefaultHealthModifier.get().floatValue(), (float)TFCConfig.SERVER.nutritionMaximumHealthModifier.get().floatValue());
    }

    default public void eat(ItemStack stack) {
        @Nullable IFood food = FoodCapability.get(stack);
        if (food != null) {
            this.eat(food);
        }
    }

    public void eat(IFood var1);

    public void eat(FoodData var1);

    public void onClientUpdate(PlayerInfoPacket var1);

    public void copyOnDeath(IPlayerInfo var1);

    public void forceUpdate();
}

