/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.VisibleForTesting;

public class AdvancedShapelessRecipe
extends ShapelessRecipe {
    public static final MapCodec<AdvancedShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
        Object[] values = (Ingredient[])list.toArray(Ingredient[]::new);
        int length = ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth();
        return values.length == 0 ? DataResult.error(() -> "No ingredients for shapeless recipe") : (values.length > length ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(length)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])values)));
    }, DataResult::success).forGetter(ShapelessRecipe::getIngredients), (App)ItemStackProvider.CODEC.fieldOf("result").forGetter(c -> c.result), (App)ItemStackProvider.CODEC.optionalFieldOf("remainder").forGetter(c -> c.remainder), (App)Ingredient.CODEC.optionalFieldOf("primary_ingredient").forGetter(c -> c.primaryIngredient)).apply((Applicative)i, AdvancedShapelessRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AdvancedShapelessRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()).map(NonNullList::copyOf, Function.identity()), ShapelessRecipe::getIngredients, ItemStackProvider.STREAM_CODEC, c -> c.result, (StreamCodec)ByteBufCodecs.optional(ItemStackProvider.STREAM_CODEC), c -> c.remainder, (StreamCodec)ByteBufCodecs.optional((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), c -> c.primaryIngredient, AdvancedShapelessRecipe::new);
    private final ItemStackProvider result;
    private final Optional<ItemStackProvider> remainder;
    private final Optional<Ingredient> primaryIngredient;

    public AdvancedShapelessRecipe(NonNullList<Ingredient> ingredients, ItemStackProvider result, Optional<ItemStackProvider> remainder, Optional<Ingredient> primaryIngredient) {
        super("", CraftingBookCategory.MISC, ItemStack.EMPTY, ingredients);
        this.result = result;
        this.remainder = remainder;
        this.primaryIngredient = primaryIngredient;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        RecipeHelpers.setCraftingInput(input);
        ItemStack output = this.result.getSingleStack(this.getPrimaryInput(input).copy());
        RecipeHelpers.clearCraftingInput();
        return output;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result.getEmptyStack();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        return this.remainder.map(remainder -> {
            RecipeHelpers.setCraftingInput(input);
            NonNullList<ItemStack> remain = RecipeHelpers.getRemainderItemsWithProvider(input, remainder, this.getPrimaryInput(input));
            RecipeHelpers.clearCraftingInput();
            return remain;
        }).orElseGet(() -> super.getRemainingItems((RecipeInput)input));
    }

    private ItemStack getPrimaryInput(CraftingInput input) {
        Ingredient primaryInput = this.primaryIngredient.orElseThrow();
        for (int i = 0; i < input.size(); ++i) {
            ItemStack item = input.getItem(i);
            if (!primaryInput.test(item)) continue;
            return item;
        }
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return this.result.dependsOnInput();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.ADVANCED_SHAPELESS_CRAFTING.get();
    }

    public ItemStackProvider getResult() {
        return this.result;
    }

    @VisibleForTesting
    public Optional<ItemStackProvider> getRemainder() {
        return this.remainder;
    }

    @VisibleForTesting
    public Optional<Ingredient> getPrimaryIngredient() {
        return this.primaryIngredient;
    }
}

