/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.component.mold.IMold;
import net.dries007.tfc.common.recipes.INoopInputRecipe;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public class CastingRecipe
implements INoopInputRecipe,
IRecipePredicate<IMold> {
    public static final MapCodec<CastingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Ingredient.CODEC.fieldOf("mold").forGetter(c -> c.ingredient), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid").forGetter(c -> c.fluidIngredient), (App)ItemStackProvider.CODEC.fieldOf("result").forGetter(c -> c.result), (App)Codec.FLOAT.optionalFieldOf("break_chance", (Object)Float.valueOf(1.0f)).forGetter(c -> Float.valueOf(c.breakChance))).apply((Applicative)i, CastingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CastingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.ingredient, (StreamCodec)SizedFluidIngredient.STREAM_CODEC, c -> c.fluidIngredient, ItemStackProvider.STREAM_CODEC, c -> c.result, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.breakChance), CastingRecipe::new);
    public static final IndirectHashCollection<Item, CastingRecipe> CACHE = IndirectHashCollection.createForRecipe(r -> RecipeHelpers.itemKeys(r.ingredient), TFCRecipeTypes.CASTING);
    private final Ingredient ingredient;
    private final SizedFluidIngredient fluidIngredient;
    private final ItemStackProvider result;
    private final float breakChance;

    @Nullable
    public static CastingRecipe get(IMold mold) {
        return RecipeHelpers.getRecipe(CACHE, mold, mold.getContainer().getItem());
    }

    public CastingRecipe(Ingredient ingredient, SizedFluidIngredient fluidIngredient, ItemStackProvider result, float breakChance) {
        this.ingredient = ingredient;
        this.fluidIngredient = fluidIngredient;
        this.result = result;
        this.breakChance = breakChance;
    }

    @Override
    public boolean matches(IMold mold) {
        return this.ingredient.test(mold.getContainer()) && this.fluidIngredient.test(mold.getFluidInTank(0));
    }

    public ItemStack assemble(IMold mold) {
        ItemStack stack = this.result.getSingleStack(mold.getContainer().copy());
        @Nullable IHeat heat = HeatCapability.get(stack);
        if (heat != null) {
            heat.setTemperatureIfWarmer(mold.getTemperature());
        }
        return stack;
    }

    public float getBreakChance() {
        return this.breakChance;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public SizedFluidIngredient getFluidIngredient() {
        return this.fluidIngredient;
    }

    public ItemStack getResultItem() {
        return this.result.getEmptyStack();
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result.getEmptyStack();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.CASTING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.CASTING.get();
    }
}

