/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.recipes.INoopInputRecipe;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class HeatingRecipe
implements INoopInputRecipe,
IRecipePredicate<ItemStack> {
    public static final IndirectHashCollection<Item, HeatingRecipe> CACHE = IndirectHashCollection.createForRecipe(r -> RecipeHelpers.itemKeys(r.ingredient), TFCRecipeTypes.HEATING);
    public static final MapCodec<HeatingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(c -> c.ingredient), (App)ItemStackProvider.CODEC.optionalFieldOf("result_item", (Object)ItemStackProvider.empty()).forGetter(c -> c.outputItem), (App)FluidStack.CODEC.optionalFieldOf("result_fluid", (Object)FluidStack.EMPTY).forGetter(c -> c.outputFluid), (App)Codec.FLOAT.fieldOf("temperature").forGetter(c -> Float.valueOf(c.temperature)), (App)Codec.BOOL.optionalFieldOf("use_durability", (Object)false).forGetter(c -> c.useDurability)).apply((Applicative)i, HeatingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, HeatingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.ingredient, ItemStackProvider.STREAM_CODEC, c -> c.outputItem, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, c -> c.outputFluid, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.temperature), (StreamCodec)ByteBufCodecs.BOOL, c -> c.useDurability, HeatingRecipe::new);
    private final Ingredient ingredient;
    private final ItemStackProvider outputItem;
    private final FluidStack outputFluid;
    private final float temperature;
    private final boolean useDurability;

    @Nullable
    public static HeatingRecipe getRecipe(ItemStack stack) {
        return RecipeHelpers.getRecipe(CACHE, stack, stack.getItem());
    }

    public HeatingRecipe(Ingredient ingredient, ItemStackProvider outputItem, FluidStack outputFluid, float temperature, boolean useDurability) {
        this.ingredient = ingredient;
        this.outputItem = outputItem;
        this.outputFluid = outputFluid;
        this.temperature = temperature;
        this.useDurability = useDurability;
    }

    @Override
    public boolean matches(ItemStack input) {
        return this.ingredient.test(input);
    }

    public ItemStack assembleItem(ItemStack input) {
        ItemStack outputStack = this.outputItem.getSingleStack(input);
        @Nullable IHeat inputHeat = HeatCapability.get(input);
        if (inputHeat != null) {
            HeatCapability.setTemperature(outputStack, inputHeat.getTemperature());
        }
        return outputStack;
    }

    public FluidStack assembleFluid(ItemStack inputStack) {
        FluidStack outputFluid = this.outputFluid.copy();
        if (this.useDurability && !outputFluid.isEmpty() && inputStack.getMaxDamage() > 0 && inputStack.isDamageableItem()) {
            outputFluid.setAmount(Mth.floor((float)((float)outputFluid.getAmount() * (1.0f - (float)inputStack.getDamageValue() / (float)inputStack.getMaxDamage()))));
        }
        return outputFluid;
    }

    public ItemStack assembleStacked(ItemStack inputStack, int stackSizeCap, boolean isDisplay) {
        ItemStack outputStack = isDisplay ? this.outputItem.getSingleStackDisplayOnly(inputStack) : this.outputItem.getSingleStack(inputStack);
        @Nullable IHeat inputHeat = HeatCapability.get(inputStack);
        if (inputHeat != null) {
            HeatCapability.setTemperature(outputStack, inputHeat.getTemperature());
        }
        outputStack.setCount(Math.min(outputStack.getCount() * inputStack.getCount(), Math.min(outputStack.getMaxStackSize(), stackSizeCap)));
        return outputStack;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public boolean isValidTemperature(float temperatureIn) {
        return temperatureIn >= this.temperature;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public ItemStack getResultItem(@Nullable HolderLookup.Provider registries) {
        return this.outputItem.getEmptyStack();
    }

    public FluidStack getDisplayOutputFluid() {
        return this.outputFluid;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.HEATING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.HEATING.get();
    }
}

