/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.input.BarrelInventory;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class InstantBarrelRecipe
extends BarrelRecipe {
    public static final MapCodec<InstantBarrelRecipe> CODEC = BarrelRecipe.CODEC.xmap(InstantBarrelRecipe::new, Function.identity());
    public static final StreamCodec<RegistryFriendlyByteBuf, InstantBarrelRecipe> STREAM_CODEC = BarrelRecipe.STREAM_CODEC.map(InstantBarrelRecipe::new, Function.identity());

    public InstantBarrelRecipe(BarrelRecipe parent) {
        super(parent);
    }

    @Override
    public boolean matches(BarrelInventory container) {
        return super.matches(container) && this.moreItemsThanFluid(container);
    }

    private boolean moreItemsThanFluid(BarrelInventory input) {
        return this.inputItem.isEmpty() || this.outputFluid.isEmpty() || input.getFluidInTank(0).getAmount() / this.inputFluid.amount() <= input.getStackInSlot(2).getCount() / ((SizedIngredient)this.inputItem.get()).count();
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.INSTANT_BARREL.get();
    }

    @Override
    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.BARREL_INSTANT.get();
    }
}

