/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.recipes.INoopInputRecipe;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

public class LoomRecipe
implements INoopInputRecipe,
IRecipePredicate<ItemStack> {
    public static final IndirectHashCollection<Item, LoomRecipe> CACHE = IndirectHashCollection.createForRecipe(r -> RecipeHelpers.itemKeys(r.ingredient.ingredient()), TFCRecipeTypes.LOOM);
    public static final MapCodec<LoomRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)SizedIngredient.FLAT_CODEC.fieldOf("ingredient").forGetter(c -> c.ingredient), (App)ItemStackProvider.CODEC.fieldOf("result").forGetter(c -> c.result), (App)Codec.INT.fieldOf("steps").forGetter(c -> c.steps), (App)ResourceLocation.CODEC.fieldOf("texture").forGetter(c -> c.inProgressTexture)).apply((Applicative)i, LoomRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, LoomRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)SizedIngredient.STREAM_CODEC, c -> c.ingredient, ItemStackProvider.STREAM_CODEC, c -> c.result, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.steps, (StreamCodec)ResourceLocation.STREAM_CODEC, c -> c.inProgressTexture, LoomRecipe::new);
    private final SizedIngredient ingredient;
    private final ItemStackProvider result;
    private final int steps;
    private final ResourceLocation inProgressTexture;

    @Nullable
    public static LoomRecipe getRecipe(ItemStack stack) {
        return RecipeHelpers.getRecipe(CACHE, stack, stack.getItem());
    }

    public LoomRecipe(SizedIngredient ingredient, ItemStackProvider result, int steps, ResourceLocation inProgressTexture) {
        this.ingredient = ingredient;
        this.result = result;
        this.steps = steps;
        this.inProgressTexture = inProgressTexture;
    }

    @Override
    public boolean matches(ItemStack input) {
        return this.ingredient.ingredient().test(input);
    }

    public ItemStack assemble(ItemStack input) {
        return this.result.getSingleStack(input);
    }

    public SizedIngredient getItemStackIngredient() {
        return this.ingredient;
    }

    public int getInputCount() {
        return this.ingredient.count();
    }

    public ResourceLocation getInProgressTexture() {
        return this.inProgressTexture;
    }

    public int getStepCount() {
        return this.steps;
    }

    @Override
    public ItemStack getResultItem(@Nullable HolderLookup.Provider registries) {
        return this.result.getEmptyStack();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.LOOM.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.LOOM.get();
    }

    @Override
    public boolean isSpecial() {
        return this.result.dependsOnInput();
    }
}

