/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.outputs.PotOutput;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class PotRecipe
implements ISimpleRecipe<PotBlockEntity.PotInventory> {
    public static final MapCodec<PotRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Ingredient.CODEC.listOf(0, 5).fieldOf("ingredients").forGetter(c -> c.itemIngredients), (App)SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid_ingredient").forGetter(c -> c.fluidIngredient), (App)Codec.INT.fieldOf("duration").forGetter(c -> c.duration), (App)Codec.FLOAT.fieldOf("temperature").forGetter(c -> Float.valueOf(c.temperature))).apply((Applicative)i, PotRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PotRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list((int)5)), c -> c.itemIngredients, (StreamCodec)SizedFluidIngredient.STREAM_CODEC, c -> c.fluidIngredient, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.duration, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.temperature), PotRecipe::new);
    protected final List<Ingredient> itemIngredients;
    protected final SizedFluidIngredient fluidIngredient;
    protected final int duration;
    protected final float temperature;

    protected PotRecipe(PotRecipe base) {
        this(base.itemIngredients, base.fluidIngredient, base.duration, base.temperature);
    }

    public PotRecipe(List<Ingredient> itemIngredients, SizedFluidIngredient fluidIngredient, int duration, float temperature) {
        this.itemIngredients = itemIngredients;
        this.fluidIngredient = fluidIngredient;
        this.duration = duration;
        this.temperature = temperature;
    }

    public boolean matches(PotBlockEntity.PotInventory inventory, Level worldIn) {
        if (!this.fluidIngredient.test(inventory.getFluidInTank(0))) {
            return false;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 4; i <= 8; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            stacks.add(stack);
        }
        return stacks.isEmpty() && this.itemIngredients.isEmpty() || Helpers.perfectMatchExists(stacks, this.itemIngredients);
    }

    public ItemStack assemble(PotBlockEntity.PotInventory input, HolderLookup.Provider registries) {
        throw new UnsupportedOperationException();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.POT.get();
    }

    public RecipeSerializer<?> getSerializer() {
        throw new UnsupportedOperationException();
    }

    public SizedFluidIngredient getFluidIngredient() {
        return this.fluidIngredient;
    }

    public List<Ingredient> getItemIngredients() {
        return this.itemIngredients;
    }

    public boolean isHotEnough(float tempIn) {
        return tempIn > this.temperature;
    }

    public int getDuration() {
        return this.duration;
    }

    public PotOutput getOutput(PotBlockEntity.PotInventory inventory) {
        return PotOutput.EMPTY_INSTANCE;
    }
}

