/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.serialization.MapCodec;
import net.dries007.tfc.common.recipes.AdvancedShapedRecipe;
import net.dries007.tfc.common.recipes.AdvancedShapelessRecipe;
import net.dries007.tfc.common.recipes.AlloyRecipe;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.common.recipes.BlastFurnaceRecipe;
import net.dries007.tfc.common.recipes.BlockRecipe;
import net.dries007.tfc.common.recipes.BloomeryRecipe;
import net.dries007.tfc.common.recipes.CastingCraftingRecipe;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.common.recipes.ChiselRecipe;
import net.dries007.tfc.common.recipes.CollapseRecipe;
import net.dries007.tfc.common.recipes.FoodCombiningCraftingRecipe;
import net.dries007.tfc.common.recipes.GlassworkingRecipe;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.InstantBarrelRecipe;
import net.dries007.tfc.common.recipes.InstantFluidBarrelRecipe;
import net.dries007.tfc.common.recipes.JamPotRecipe;
import net.dries007.tfc.common.recipes.KnappingRecipe;
import net.dries007.tfc.common.recipes.LandslideRecipe;
import net.dries007.tfc.common.recipes.LoomRecipe;
import net.dries007.tfc.common.recipes.QuernRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.ScrapingRecipe;
import net.dries007.tfc.common.recipes.SealedBarrelRecipe;
import net.dries007.tfc.common.recipes.SewingRecipe;
import net.dries007.tfc.common.recipes.SimplePotRecipe;
import net.dries007.tfc.common.recipes.SoupPotRecipe;
import net.dries007.tfc.common.recipes.WeldingRecipe;
import net.dries007.tfc.util.registry.RegistryHolder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class TFCRecipeSerializers {
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"tfc");
    public static final Id<CollapseRecipe> COLLAPSE = TFCRecipeSerializers.register("collapse", BlockRecipe.serializer(CollapseRecipe::new));
    public static final Id<LandslideRecipe> LANDSLIDE = TFCRecipeSerializers.register("landslide", BlockRecipe.serializer(LandslideRecipe::new));
    public static final Id<ChiselRecipe> CHISEL = TFCRecipeSerializers.register("chisel", ChiselRecipe.CODEC, ChiselRecipe.STREAM_CODEC);
    public static final Id<HeatingRecipe> HEATING = TFCRecipeSerializers.register("heating", HeatingRecipe.CODEC, HeatingRecipe.STREAM_CODEC);
    public static final Id<QuernRecipe> QUERN = TFCRecipeSerializers.register("quern", QuernRecipe.CODEC, QuernRecipe.STREAM_CODEC);
    public static final Id<ScrapingRecipe> SCRAPING = TFCRecipeSerializers.register("scraping", ScrapingRecipe.CODEC, ScrapingRecipe.STREAM_CODEC);
    public static final Id<SimplePotRecipe> POT_SIMPLE = TFCRecipeSerializers.register("pot", SimplePotRecipe.CODEC, SimplePotRecipe.STREAM_CODEC);
    public static final Id<SoupPotRecipe> POT_SOUP = TFCRecipeSerializers.register("pot_soup", SoupPotRecipe.CODEC, SoupPotRecipe.STREAM_CODEC);
    public static final Id<JamPotRecipe> POT_JAM = TFCRecipeSerializers.register("pot_jam", JamPotRecipe.CODEC, JamPotRecipe.STREAM_CODEC);
    public static final Id<KnappingRecipe> KNAPPING = TFCRecipeSerializers.register("knapping", KnappingRecipe.CODEC, KnappingRecipe.STREAM_CODEC);
    public static final Id<AlloyRecipe> ALLOY = TFCRecipeSerializers.register("alloy", AlloyRecipe.CODEC, AlloyRecipe.STREAM_CODEC);
    public static final Id<CastingRecipe> CASTING = TFCRecipeSerializers.register("casting", CastingRecipe.CODEC, CastingRecipe.STREAM_CODEC);
    public static final Id<BloomeryRecipe> BLOOMERY = TFCRecipeSerializers.register("bloomery", BloomeryRecipe.CODEC, BloomeryRecipe.STREAM_CODEC);
    public static final Id<SealedBarrelRecipe> SEALED_BARREL = TFCRecipeSerializers.register("barrel_sealed", SealedBarrelRecipe.CODEC, SealedBarrelRecipe.STREAM_CODEC);
    public static final Id<InstantBarrelRecipe> INSTANT_BARREL = TFCRecipeSerializers.register("barrel_instant", InstantBarrelRecipe.CODEC, InstantBarrelRecipe.STREAM_CODEC);
    public static final Id<InstantFluidBarrelRecipe> INSTANT_FLUID_BARREL = TFCRecipeSerializers.register("barrel_instant_fluid", InstantFluidBarrelRecipe.CODEC, InstantFluidBarrelRecipe.STREAM_CODEC);
    public static final Id<LoomRecipe> LOOM = TFCRecipeSerializers.register("loom", LoomRecipe.CODEC, LoomRecipe.STREAM_CODEC);
    public static final Id<AnvilRecipe> ANVIL = TFCRecipeSerializers.register("anvil", AnvilRecipe.CODEC, AnvilRecipe.STREAM_CODEC);
    public static final Id<WeldingRecipe> WELDING = TFCRecipeSerializers.register("welding", WeldingRecipe.CODEC, WeldingRecipe.STREAM_CODEC);
    public static final Id<BlastFurnaceRecipe> BLAST_FURNACE = TFCRecipeSerializers.register("blast_furnace", BlastFurnaceRecipe.CODEC, BlastFurnaceRecipe.STREAM_CODEC);
    public static final Id<GlassworkingRecipe> GLASSWORKING = TFCRecipeSerializers.register("glassworking", GlassworkingRecipe.CODEC, GlassworkingRecipe.STREAM_CODEC);
    public static final Id<SewingRecipe> SEWING = TFCRecipeSerializers.register("sewing", SewingRecipe.CODEC, SewingRecipe.STREAM_CODEC);
    public static final Id<FoodCombiningCraftingRecipe> FOOD_COMBINING_CRAFTING = TFCRecipeSerializers.register("food_combining", new RecipeSerializerImpl<FoodCombiningCraftingRecipe>(FoodCombiningCraftingRecipe.INSTANCE));
    public static final Id<CastingCraftingRecipe> CASTING_CRAFTING = TFCRecipeSerializers.register("casting_crafting", new RecipeSerializerImpl<CastingCraftingRecipe>(CastingCraftingRecipe.INSTANCE));
    public static final Id<AdvancedShapedRecipe> ADVANCED_SHAPED_CRAFTING = TFCRecipeSerializers.register("advanced_shaped_crafting", AdvancedShapedRecipe.CODEC, AdvancedShapedRecipe.STREAM_CODEC);
    public static final Id<AdvancedShapelessRecipe> ADVANCED_SHAPELESS_CRAFTING = TFCRecipeSerializers.register("advanced_shapeless_crafting", AdvancedShapelessRecipe.CODEC, AdvancedShapelessRecipe.STREAM_CODEC);

    private static <R extends Recipe<?>> Id<R> register(String name, MapCodec<R> codec, StreamCodec<RegistryFriendlyByteBuf, R> stream) {
        return TFCRecipeSerializers.register(name, new RecipeSerializerImpl<R>(codec, stream));
    }

    private static <R extends Recipe<?>> Id<R> register(String name, RecipeSerializer<R> serializer) {
        return new Id(RECIPE_SERIALIZERS.register(name, () -> serializer));
    }

    public record Id<T extends Recipe<?>>(DeferredHolder<RecipeSerializer<?>, RecipeSerializer<T>> holder) implements RegistryHolder<RecipeSerializer<?>, RecipeSerializer<T>>
    {
    }
}

