/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.dries007.tfc.common.component.forge.ForgingBonus;
import net.dries007.tfc.common.component.forge.ForgingBonusComponent;
import net.dries007.tfc.common.recipes.INoopInputRecipe;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.network.StreamCodecs;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public class WeldingRecipe
implements INoopInputRecipe,
IRecipePredicate<Inventory> {
    public static final MapCodec<WeldingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Ingredient.CODEC.fieldOf("first_input").forGetter(c -> c.firstInput), (App)Ingredient.CODEC.fieldOf("second_input").forGetter(c -> c.secondInput), (App)Codec.INT.optionalFieldOf("tier", (Object)0).forGetter(c -> c.tier), (App)ItemStackProvider.CODEC.fieldOf("result").forGetter(c -> c.output), (App)Behavior.CODEC.optionalFieldOf("bonus", (Object)Behavior.IGNORE).forGetter(c -> c.bonus)).apply((Applicative)i, WeldingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WeldingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.firstInput, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.secondInput, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.tier, ItemStackProvider.STREAM_CODEC, c -> c.output, Behavior.STREAM_CODEC, c -> c.bonus, WeldingRecipe::new);
    private final Ingredient firstInput;
    private final Ingredient secondInput;
    private final int tier;
    private final ItemStackProvider output;
    private final Behavior bonus;

    public WeldingRecipe(Ingredient firstInput, Ingredient secondInput, int tier, ItemStackProvider output, Behavior bonus) {
        this.firstInput = firstInput;
        this.secondInput = secondInput;
        this.tier = tier;
        this.output = output;
        this.bonus = bonus;
    }

    public boolean isCorrectTier(int anvilTier) {
        return anvilTier >= this.tier;
    }

    public int getTier() {
        return this.tier;
    }

    @Override
    public boolean matches(Inventory input) {
        ItemStack left = input.getLeft();
        ItemStack right = input.getRight();
        return this.firstInput.test(left) && this.secondInput.test(right) || this.firstInput.test(right) && this.secondInput.test(left);
    }

    public ItemStack assemble(Inventory input) {
        ItemStack stack = this.output.getSingleStack(input.getLeft());
        if (this.bonus != Behavior.IGNORE) {
            ForgingBonus left = ForgingBonusComponent.get(input.getLeft());
            ForgingBonus right = ForgingBonusComponent.get(input.getRight());
            boolean leftIsHigher = left.ordinal() > right.ordinal();
            boolean copyHigher = this.bonus == Behavior.COPY_BEST;
            ForgingBonusComponent.copy(leftIsHigher == copyHigher ? input.getLeft() : input.getRight(), stack);
        }
        return stack;
    }

    @Override
    public ItemStack getResultItem(@Nullable HolderLookup.Provider registries) {
        return this.output.getEmptyStack();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TFCRecipeSerializers.WELDING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TFCRecipeTypes.WELDING.get();
    }

    public Ingredient getFirstInput() {
        return this.firstInput;
    }

    public Ingredient getSecondInput() {
        return this.secondInput;
    }

    public static enum Behavior implements StringRepresentable
    {
        COPY_BEST,
        COPY_WORST,
        IGNORE;

        public static final Codec<Behavior> CODEC;
        public static final StreamCodec<ByteBuf, Behavior> STREAM_CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Behavior::values);
            STREAM_CODEC = StreamCodecs.forEnum(Behavior::values);
        }
    }

    public static interface Inventory
    extends RecipeInput {
        public ItemStack getLeft();

        public ItemStack getRight();

        public int getTier();
    }
}

