/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.dries007.tfc.common.recipes.ingredients.PreciseIngredient;
import net.dries007.tfc.common.recipes.ingredients.TFCIngredients;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public record AndIngredient(List<Ingredient> children) implements ICustomIngredient
{
    public static final MapCodec<AndIngredient> CODEC = Ingredient.CODEC.listOf().xmap(AndIngredient::new, AndIngredient::children).fieldOf("children");
    public static final StreamCodec<RegistryFriendlyByteBuf, AndIngredient> STREAM_CODEC = Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()).map(AndIngredient::new, AndIngredient::children);

    public static Ingredient of(Ingredient ingredient, ICustomIngredient ... others) {
        return new AndIngredient(Stream.concat(Stream.of(ingredient), Arrays.stream(others).map(ICustomIngredient::toVanilla)).toList()).toVanilla();
    }

    public boolean test(ItemStack stack) {
        for (Ingredient child : this.children) {
            if (child.test(stack)) continue;
            return false;
        }
        return true;
    }

    public Stream<ItemStack> getItems() {
        return Arrays.stream(this.children.getFirst().getItems()).map(stack -> {
            for (Ingredient other : this.children) {
                ICustomIngredient patt0$temp = other.getCustomIngredient();
                if (!(patt0$temp instanceof PreciseIngredient)) continue;
                PreciseIngredient precise = (PreciseIngredient)patt0$temp;
                stack = precise.modifyStackForDisplay((ItemStack)stack);
            }
            return stack;
        });
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)TFCIngredients.AND.get();
    }
}

