/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import java.util.stream.Stream;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.ingredients.TFCIngredients;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public record FluidContentIngredient(SizedFluidIngredient fluid) implements ICustomIngredient
{
    public static final MapCodec<FluidContentIngredient> CODEC = SizedFluidIngredient.FLAT_CODEC.fieldOf("fluid").xmap(FluidContentIngredient::new, FluidContentIngredient::fluid);
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidContentIngredient> STREAM_CODEC = SizedFluidIngredient.STREAM_CODEC.map(FluidContentIngredient::new, FluidContentIngredient::fluid);

    public static Ingredient of(Fluid fluid, int amount) {
        return new FluidContentIngredient(SizedFluidIngredient.of((Fluid)fluid, (int)amount)).toVanilla();
    }

    public boolean test(ItemStack stack) {
        return this.fluid.test(FluidHelpers.getContainedFluid(stack));
    }

    public Stream<ItemStack> getItems() {
        return RecipeHelpers.stream(this.fluid).flatMap(fluid -> Helpers.allItems(TFCTags.Items.FLUID_ITEM_INGREDIENT_EMPTY_CONTAINERS).map(item -> {
            ItemStack stack = new ItemStack((ItemLike)item);
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidHandler != null) {
                fluidHandler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE);
                FluidStack content = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (content.getFluid() == fluid && content.getAmount() >= this.fluid.amount()) {
                    return fluidHandler.getContainer();
                }
            }
            return null;
        })).filter(Objects::nonNull);
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)TFCIngredients.FLUID_CONTENT.get();
    }
}

