/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.dries007.tfc.common.Lore;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.recipes.ingredients.PreciseIngredient;
import net.dries007.tfc.common.recipes.ingredients.TFCIngredients;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.dries007.tfc.world.Codecs;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public record HeatIngredient(float min, float max) implements PreciseIngredient
{
    private static final float MIN = Float.NEGATIVE_INFINITY;
    private static final float MAX = Float.POSITIVE_INFINITY;
    public static final MapCodec<HeatIngredient> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codecs.POSITIVE_FLOAT.optionalFieldOf("min", (Object)Float.valueOf(Float.NEGATIVE_INFINITY)).forGetter(c -> Float.valueOf(c.min)), (App)Codecs.POSITIVE_FLOAT.optionalFieldOf("max", (Object)Float.valueOf(Float.POSITIVE_INFINITY)).forGetter(c -> Float.valueOf(c.max))).apply((Applicative)i, HeatIngredient::new)).flatXmap(c -> c.min == Float.NEGATIVE_INFINITY && c.max == Float.POSITIVE_INFINITY ? DataResult.error(() -> "Must have one of min or max") : DataResult.success((Object)c), DataResult::success);
    public static final StreamCodec<ByteBuf, HeatIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.min), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.max), HeatIngredient::new);

    public static Ingredient min(float min) {
        return new HeatIngredient(min, Float.POSITIVE_INFINITY).toVanilla();
    }

    public boolean test(ItemStack stack) {
        float temperature = HeatCapability.getTemperature(stack);
        return temperature >= this.min && temperature <= this.max;
    }

    @Override
    public ItemStack modifyStackForDisplay(ItemStack stack) {
        HeatCapability.setStaticTemperature(stack, this.min != Float.NEGATIVE_INFINITY ? this.min : this.max);
        Lore.append(stack, Tooltips.require((Component)(this.min == Float.NEGATIVE_INFINITY ? null : TFCConfig.CLIENT.heatTooltipStyle.get().formatColored(this.min)), this.max == Float.POSITIVE_INFINITY ? null : TFCConfig.CLIENT.heatTooltipStyle.get().formatColored(this.max)));
        return stack;
    }

    public IngredientType<?> getType() {
        return (IngredientType)TFCIngredients.HEAT.get();
    }
}

