/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.recipes.ingredients.PreciseIngredient;
import net.dries007.tfc.common.recipes.ingredients.TFCIngredients;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.IngredientType;

public enum NotRottenIngredient implements PreciseIngredient
{
    INSTANCE;

    public static final MapCodec<NotRottenIngredient> CODEC;
    public static final StreamCodec<ByteBuf, NotRottenIngredient> STREAM_CODEC;

    public boolean test(ItemStack stack) {
        return !FoodCapability.isRotten(stack);
    }

    @Override
    public ItemStack modifyStackForDisplay(ItemStack stack) {
        return FoodCapability.setInvisibleNonDecaying(stack);
    }

    public IngredientType<?> getType() {
        return (IngredientType)TFCIngredients.NOT_ROTTEN.get();
    }

    static {
        CODEC = MapCodec.unit((Object)INSTANCE);
        STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);
    }
}

