/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.outputs;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifierType;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifiers;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record AddHeatModifier(float temperature) implements ItemStackModifier
{
    public static final MapCodec<AddHeatModifier> CODEC = Codec.FLOAT.fieldOf("temperature").xmap(AddHeatModifier::new, AddHeatModifier::temperature);
    public static final StreamCodec<RegistryFriendlyByteBuf, AddHeatModifier> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.temperature), AddHeatModifier::new);

    public static AddHeatModifier of(float temperature) {
        return new AddHeatModifier(temperature);
    }

    @Override
    public ItemStack apply(ItemStack stack, ItemStack input, ItemStackModifier.Context context) {
        @Nullable IHeat heat = HeatCapability.get(stack);
        if (heat != null) {
            heat.setTemperature(heat.getTemperature() + this.temperature);
        }
        return stack;
    }

    @Override
    public ItemStackModifierType<?> type() {
        return (ItemStackModifierType)ItemStackModifiers.ADD_HEAT.get();
    }
}

