/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.outputs;

import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.recipes.JamPotRecipe;
import net.dries007.tfc.common.recipes.SoupPotRecipe;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.tooltip.BlockEntityTooltip;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.Nullable;

public interface PotOutput {
    public static final ResourceKey<Registry<OutputType>> KEY = ResourceKey.createRegistryKey((ResourceLocation)Helpers.identifier("pot_output"));
    public static final ResourceKey<OutputType> DEFAULT = ResourceKey.create(KEY, (ResourceLocation)Helpers.identifier("empty"));
    public static final DefaultedRegistry<OutputType> REGISTRY = (DefaultedRegistry)new RegistryBuilder(KEY).sync(true).defaultKey(DEFAULT).create();
    public static final DeferredRegister<OutputType> TYPES = DeferredRegister.create(KEY, (String)"tfc");
    public static final PotOutput EMPTY_INSTANCE = new PotOutput(){};
    public static final DeferredHolder<OutputType, OutputType> EMPTY = PotOutput.register("empty", (provider, nbt) -> EMPTY_INSTANCE);
    public static final DeferredHolder<OutputType, OutputType> SOUP = PotOutput.register("soup", SoupPotRecipe.OUTPUT_TYPE);
    public static final DeferredHolder<OutputType, OutputType> JAM = PotOutput.register("jam", JamPotRecipe.OUTPUT_TYPE);

    private static DeferredHolder<OutputType, OutputType> register(String name, OutputType output) {
        return TYPES.register(name, () -> output);
    }

    public static PotOutput read(HolderLookup.Provider provider, CompoundTag nbt) {
        return ((OutputType)REGISTRY.get(Helpers.resourceLocation(nbt.getString("type")))).read(provider, nbt);
    }

    public static CompoundTag write(HolderLookup.Provider provider, PotOutput output) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("type", REGISTRY.getKey((Object)output.getType()).toString());
        output.write(provider, nbt);
        return nbt;
    }

    default public boolean isEmpty() {
        return true;
    }

    default public int getFluidColor() {
        return -1;
    }

    @Nullable
    default public ResourceLocation getRenderTexture() {
        return null;
    }

    default public float getFluidYLevel() {
        return 0.625f;
    }

    default public void onFinish(PotBlockEntity.PotInventory inventory) {
    }

    default public ItemInteractionResult onInteract(PotBlockEntity entity, Player player, ItemStack clickedWith) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    default public OutputType getType() {
        return (OutputType)EMPTY.get();
    }

    default public void write(HolderLookup.Provider provider, CompoundTag nbt) {
    }

    @Nullable
    default public BlockEntityTooltip getTooltip() {
        return null;
    }

    @FunctionalInterface
    public static interface OutputType {
        public PotOutput read(HolderLookup.Provider var1, CompoundTag var2);
    }
}

