/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.dries007.tfc.client.screen.CalendarScreen;
import net.dries007.tfc.client.screen.ClimateScreen;
import net.dries007.tfc.client.screen.NutritionScreen;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.AdvancedShapedRecipe;
import net.dries007.tfc.common.recipes.AdvancedShapelessRecipe;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.ItemRecipe;
import net.dries007.tfc.common.recipes.JamPotRecipe;
import net.dries007.tfc.common.recipes.KnappingRecipe;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.ScrapingRecipe;
import net.dries007.tfc.common.recipes.SimplePotRecipe;
import net.dries007.tfc.common.recipes.SoupPotRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.handlers.EmiAnvilHandler;
import net.dries007.tfc.compat.emi.handlers.EmiFirepitHandler;
import net.dries007.tfc.compat.emi.handlers.EmiForgeHandler;
import net.dries007.tfc.compat.emi.handlers.EmiGrillHandler;
import net.dries007.tfc.compat.emi.handlers.EmiSewingHandler;
import net.dries007.tfc.compat.emi.handlers.EmiWeldingHandler;
import net.dries007.tfc.compat.emi.recipe.ComparableRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiAdvancedShapedRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiAdvancedShapelessRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiAlloyingRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiAnvilRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiBlastFurnaceRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiBloomeryRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiCastingRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiChiselRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiGlassworkingRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiHeatingRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiInstantBarrelRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiInstantFluidBarrelRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiJamPotRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiKnappingRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiLoomRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiQuernRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiSealedBarrelRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiSewingRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiSimplePotRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiSoupPotRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiWeldingRecipe;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.data.KnappingType;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;

@EmiEntrypoint
public final class EmiIntegration
implements EmiPlugin {
    private static final List<EmiRecipeCategory> CATEGORIES = new ArrayList<EmiRecipeCategory>();
    public static final EmiRecipeCategory ALLOYING = EmiIntegration.createCategory("alloying", TFCBlocks.CRUCIBLE);
    public static final EmiRecipeCategory BLOOMERY = EmiIntegration.createCategory("bloomery", TFCBlocks.BLOOMERY);
    public static final EmiRecipeCategory BLAST_FURNACE = EmiIntegration.createCategory("blast_furnace", TFCBlocks.BLAST_FURNACE);
    public static final EmiRecipeCategory CASTING = EmiIntegration.createCategory("casting", TFCItems.MOLDS.get((Object)Metal.ItemType.INGOT));
    public static final EmiRecipeCategory CHISEL = EmiIntegration.createCategory("chisel", TFCItems.METAL_ITEMS.get(Metal.BLACK_BRONZE).get((Object)Metal.ItemType.CHISEL));
    public static final EmiRecipeCategory ANVIL = EmiIntegration.createCategory("anvil", TFCBlocks.METALS.get(Metal.BRONZE).get((Object)Metal.BlockType.ANVIL));
    public static final EmiRecipeCategory HEATING = EmiIntegration.createCategory("heating", TFCBlocks.FIREPIT);
    public static final EmiRecipeCategory BARREL = EmiIntegration.createCategory("barrel", TFCBlocks.WOODS.get(Wood.OAK).get((Object)Wood.BlockType.BARREL));
    public static final EmiRecipeCategory WELDING = EmiIntegration.createCategory("welding", TFCItems.METAL_ITEMS.get(Metal.WROUGHT_IRON).get((Object)Metal.ItemType.HAMMER));
    public static final EmiRecipeCategory GLASSWORKING = EmiIntegration.createCategory("glassworking", TFCItems.BLOWPIPE_WITH_GLASS);
    public static final EmiRecipeCategory POT = EmiIntegration.createCategory("pot", TFCItems.POT);
    public static final EmiRecipeCategory LOOM = EmiIntegration.createCategory("loom", TFCItems.BURLAP_CLOTH);
    public static final EmiRecipeCategory QUERN = EmiIntegration.createCategory("quern", TFCBlocks.QUERN);
    public static final EmiRecipeCategory SCRAPING = EmiIntegration.createCategory("scraping", TFCItems.METAL_ITEMS.get(Metal.BLACK_BRONZE).get((Object)Metal.ItemType.KNIFE));
    public static final EmiRecipeCategory SEWING = EmiIntegration.createCategory("sewing", TFCItems.BONE_NEEDLE);
    public static final HashMap<KnappingType, EmiRecipeCategory> KNAPPING = new HashMap();

    private static EmiRecipeCategory createCategory(String name, ItemLike item) {
        EmiRecipeCategory category = new EmiRecipeCategory(Helpers.identifier(name), (EmiRenderable)EmiStack.of((ItemLike)item));
        CATEGORIES.add(category);
        return category;
    }

    private static EmiRecipeCategory createCategory(String name, ItemStack item) {
        EmiRecipeCategory category = new EmiRecipeCategory(Helpers.identifier(name), (EmiRenderable)EmiStack.of((ItemStack)item));
        CATEGORIES.add(category);
        return category;
    }

    private static <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> recipes(RecipeManager manager, Supplier<RecipeType<T>> type) {
        return manager.getAllRecipesFor(type.get()).stream().toList();
    }

    public void register(EmiRegistry registry) {
        this.registerCategories(registry);
        this.registerWorkstations(registry);
        this.registerRecipes(registry);
        this.registerRecipeHandlers(registry);
        this.registerExclusionZones(registry);
        this.overrideRecipes(registry);
    }

    private void registerCategories(EmiRegistry registry) {
        for (Map.Entry<ResourceLocation, KnappingType> entry : KnappingType.MANAGER.getElements().entrySet()) {
            KnappingType knappingType = entry.getValue();
            EmiRecipeCategory category = EmiIntegration.createCategory(entry.getKey().getPath() + "_knapping", knappingType.icon());
            KNAPPING.put(knappingType, category);
        }
        for (EmiRecipeCategory category : CATEGORIES) {
            registry.addCategory(category);
            category.sorter = EmiIntegration.basicSorter();
        }
        EmiIntegration.ALLOYING.sorter = EmiIntegration.sortByInput();
        EmiIntegration.GLASSWORKING.sorter = EmiIntegration.sortByInput();
    }

    private void registerWorkstations(EmiRegistry registry) {
        registry.addWorkstation(HEATING, (EmiIngredient)EmiStack.of(TFCBlocks.FIREPIT));
        registry.addWorkstation(HEATING, (EmiIngredient)EmiStack.of(TFCBlocks.GRILL));
        registry.addWorkstation(BARREL, EmiIngredient.of(TFCTags.Items.BARRELS));
        registry.addWorkstation(ALLOYING, (EmiIngredient)EmiStack.of(TFCBlocks.CRUCIBLE));
        registry.addWorkstation(ALLOYING, EmiIngredient.of(TFCTags.Items.FIRED_VESSELS));
        registry.addWorkstation(ANVIL, EmiIngredient.of(TFCTags.Blocks.ANVILS));
        registry.addWorkstation(WELDING, EmiIngredient.of(TFCTags.Blocks.ANVILS));
        registry.addWorkstation(BLAST_FURNACE, (EmiIngredient)EmiStack.of(TFCBlocks.BLAST_FURNACE));
        registry.addWorkstation(CASTING, EmiIngredient.of(TFCTags.Items.FIRED_MOLDS));
        registry.addWorkstation(BLOOMERY, (EmiIngredient)EmiStack.of(TFCBlocks.BLOOMERY));
        registry.addWorkstation(CHISEL, EmiIngredient.of(TFCTags.Items.TOOLS_CHISEL));
        registry.addWorkstation(GLASSWORKING, (EmiIngredient)EmiStack.of((ItemLike)TFCItems.BLOWPIPE_WITH_GLASS));
        registry.addWorkstation(GLASSWORKING, (EmiIngredient)EmiStack.of((ItemLike)TFCItems.CERAMIC_BLOWPIPE_WITH_GLASS));
        registry.addWorkstation(GLASSWORKING, (EmiIngredient)EmiStack.of((ItemLike)TFCItems.GEM_SAW));
        registry.addWorkstation(GLASSWORKING, (EmiIngredient)EmiStack.of((ItemLike)TFCItems.JACKS));
        registry.addWorkstation(LOOM, EmiIngredient.of(TFCBlocks.WOODS.values().stream().map(wood -> (TFCBlocks.Id)wood.get((Object)Wood.BlockType.LOOM)).map(EmiStack::of).toList()));
        registry.addWorkstation(QUERN, (EmiIngredient)EmiStack.of(TFCBlocks.QUERN));
        registry.addWorkstation(QUERN, (EmiIngredient)EmiStack.of((ItemLike)TFCItems.HANDSTONE));
        registry.addWorkstation(POT, (EmiIngredient)EmiStack.of(TFCBlocks.POT));
        for (Map.Entry<KnappingType, EmiRecipeCategory> knap : KNAPPING.entrySet()) {
            KnappingType type = knap.getKey();
            EmiRecipeCategory category = knap.getValue();
            registry.addWorkstation(category, EmiIngredient.of(Arrays.stream(type.inputItem().getItems()).map(EmiStack::of).toList()));
        }
    }

    private void registerRecipes(EmiRegistry registry) {
        ISimpleRecipe<PotBlockEntity.PotInventory> recipe;
        ResourceLocation id;
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.HEATING, EmiHeatingRecipe::new);
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.ALLOY, EmiAlloyingRecipe::new);
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.ANVIL, EmiAnvilRecipe::new);
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.WELDING, EmiWeldingRecipe::new);
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.BLAST_FURNACE, EmiBlastFurnaceRecipe::new);
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.CASTING, EmiCastingRecipe::new);
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.BLOOMERY, EmiBloomeryRecipe::new);
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.CHISEL, EmiChiselRecipe::new);
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.GLASSWORKING, EmiGlassworkingRecipe::new);
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.LOOM, EmiLoomRecipe::new);
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.QUERN, EmiQuernRecipe::new);
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.SEWING, EmiSewingRecipe::new);
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.BARREL_SEALED, EmiSealedBarrelRecipe::new);
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.BARREL_INSTANT, EmiInstantBarrelRecipe::new);
        EmiIntegration.basicRecipeMapping(registry, TFCRecipeTypes.BARREL_INSTANT_FLUID, EmiInstantFluidBarrelRecipe::new);
        for (RecipeHolder entry : EmiIntegration.recipes(registry.getRecipeManager(), TFCRecipeTypes.POT)) {
            id = entry.id();
            recipe = (PotRecipe)entry.value();
            RecipeSerializer<?> serializer = ((PotRecipe)recipe).getSerializer();
            if (serializer == TFCRecipeSerializers.POT_JAM.get()) {
                registry.addRecipe((EmiRecipe)new EmiJamPotRecipe(id, (JamPotRecipe)recipe));
                continue;
            }
            if (serializer == TFCRecipeSerializers.POT_SOUP.get()) {
                registry.addRecipe((EmiRecipe)new EmiSoupPotRecipe(id, (SoupPotRecipe)recipe));
                continue;
            }
            if (serializer != TFCRecipeSerializers.POT_SIMPLE.get()) continue;
            registry.addRecipe((EmiRecipe)new EmiSimplePotRecipe(id, (SimplePotRecipe)recipe));
        }
        for (RecipeHolder entry : EmiIntegration.recipes(registry.getRecipeManager(), TFCRecipeTypes.KNAPPING)) {
            KnappingRecipe recipe2 = (KnappingRecipe)entry.value();
            KnappingType type = recipe2.knappingType().get();
            EmiRecipeCategory category = KNAPPING.get(type);
            registry.addRecipe((EmiRecipe)new EmiKnappingRecipe(category, entry.id(), recipe2));
        }
        for (RecipeHolder entry : EmiIntegration.recipes(registry.getRecipeManager(), TFCRecipeTypes.SCRAPING)) {
            id = entry.id();
            recipe = (ScrapingRecipe)entry.value();
            ItemStack extra = ((ScrapingRecipe)recipe).getExtraDrop().getEmptyStack();
            EmiWorldInteractionRecipe.Builder builder = EmiWorldInteractionRecipe.builder().id(id).leftInput(EmiIngredient.of((Ingredient)((ItemRecipe)recipe).getIngredient()), EmiHelpers.addTooltipToSlot("tfc.tooltip.scraping.placement")).rightInput(EmiIngredient.of(TFCTags.Blocks.SCRAPING_SURFACE), true).rightInput(EmiHelpers.damagedTool(EmiIngredient.of(TFCTags.Items.TOOLS_KNIFE), 16), true).output(EmiStack.of((ItemStack)((ItemRecipe)recipe).getResultItem(null)));
            if (!extra.isEmpty()) {
                builder.output(EmiStack.of((ItemStack)extra));
            }
            registry.addRecipe((EmiRecipe)builder.build());
        }
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(EmiHelpers.syntheticId("build_firepit")).leftInput(EmiIngredient.of(TFCTags.Items.FIREPIT_LOGS)).leftInput(EmiIngredient.of(TFCTags.Items.FIREPIT_STICKS, (long)4L)).leftInput(EmiIngredient.of(TFCTags.Items.FIREPIT_KINDLING), EmiHelpers.addTooltipToSlot("tfc.tooltip.kindling")).rightInput(EmiHelpers.damagedTool((EmiIngredient)EmiStack.of((ItemLike)TFCItems.FIRESTARTER), 1), false).output(EmiStack.of(TFCBlocks.FIREPIT)).build());
        registry.addRecipe((EmiRecipe)EmiHelpers.useItemOn("build_grill", (EmiIngredient)EmiStack.of((ItemLike)TFCItems.WROUGHT_IRON_GRILL), (EmiIngredient)EmiStack.of(TFCBlocks.FIREPIT), EmiStack.of(TFCBlocks.GRILL)));
        registry.addRecipe((EmiRecipe)EmiHelpers.useItemOn("build_pot", (EmiIngredient)EmiStack.of((ItemLike)TFCItems.POT), (EmiIngredient)EmiStack.of(TFCBlocks.FIREPIT), EmiStack.of(TFCBlocks.POT)));
        registry.addRecipe((EmiRecipe)EmiHelpers.useItemOn("build_stove_pot", (EmiIngredient)EmiStack.of((ItemLike)TFCItems.POT), (EmiIngredient)EmiStack.of(TFCBlocks.STOVE), EmiStack.of(TFCBlocks.STOVE_POT)));
        ArrayList<TFCBlocks.Id<Block>> wattle = new ArrayList<TFCBlocks.Id<Block>>(TFCBlocks.STAINED_WATTLE.values());
        wattle.add(TFCBlocks.UNSTAINED_WATTLE);
        registry.addRecipe((EmiRecipe)EmiHelpers.useItemOn("daub_wattle", List.of(EmiIngredient.of((TagKey)Tags.Items.RODS_WOODEN, (long)4L), EmiStack.of((ItemLike)TFCItems.DAUB)), (EmiIngredient)EmiStack.of(TFCBlocks.WATTLE), EmiStack.of(TFCBlocks.UNSTAINED_WATTLE), false));
        for (DyeColor color : DyeColor.values()) {
            registry.addRecipe((EmiRecipe)EmiHelpers.useItemOn("dye_wattle/" + color.getName(), EmiIngredient.of((TagKey)color.getTag()), EmiIngredient.of(wattle.stream().map(EmiStack::of).toList()), EmiStack.of((ItemLike)TFCBlocks.STAINED_WATTLE.get(color))));
        }
    }

    private void registerRecipeHandlers(EmiRegistry registry) {
        registry.addRecipeHandler((MenuType)TFCContainerTypes.ANVIL.get(), (EmiRecipeHandler)new EmiWeldingHandler());
        registry.addRecipeHandler((MenuType)TFCContainerTypes.ANVIL.get(), (EmiRecipeHandler)new EmiAnvilHandler());
        registry.addRecipeHandler((MenuType)TFCContainerTypes.FIREPIT.get(), (EmiRecipeHandler)new EmiFirepitHandler());
        registry.addRecipeHandler((MenuType)TFCContainerTypes.GRILL.get(), (EmiRecipeHandler)new EmiGrillHandler());
        registry.addRecipeHandler((MenuType)TFCContainerTypes.CHARCOAL_FORGE.get(), (EmiRecipeHandler)new EmiForgeHandler());
        registry.addRecipeHandler((MenuType)TFCContainerTypes.SEWING_TABLE.get(), (EmiRecipeHandler)new EmiSewingHandler());
    }

    private void registerExclusionZones(EmiRegistry registry) {
        registry.addExclusionArea(InventoryScreen.class, EmiHelpers.inventoryTabExclusionArea());
        registry.addExclusionArea(CalendarScreen.class, EmiHelpers.inventoryTabExclusionArea());
        registry.addExclusionArea(NutritionScreen.class, EmiHelpers.inventoryTabExclusionArea());
        registry.addExclusionArea(ClimateScreen.class, EmiHelpers.inventoryTabExclusionArea());
    }

    private void overrideRecipes(EmiRegistry registry) {
        ArrayList<ResourceLocation> removedRecipes = new ArrayList<ResourceLocation>();
        for (RecipeHolder entry : registry.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING)) {
            ResourceLocation id = entry.id();
            CraftingRecipe recipe = (CraftingRecipe)entry.value();
            if (recipe instanceof AdvancedShapelessRecipe) {
                AdvancedShapelessRecipe asr = (AdvancedShapelessRecipe)recipe;
                removedRecipes.add(id);
                registry.addRecipe((EmiRecipe)new EmiAdvancedShapelessRecipe(id.withPath("/" + id.getPath()), asr));
                continue;
            }
            if (!(recipe instanceof AdvancedShapedRecipe)) continue;
            AdvancedShapedRecipe asr = (AdvancedShapedRecipe)recipe;
            removedRecipes.add(id);
            registry.addRecipe((EmiRecipe)new EmiAdvancedShapedRecipe(id.withPath("/" + id.getPath()), asr));
        }
        registry.removeRecipes(r -> removedRecipes.contains(r.getId()));
    }

    private static <C extends RecipeInput, T extends Recipe<C>> void basicRecipeMapping(EmiRegistry registry, Supplier<RecipeType<T>> type, BiFunction<ResourceLocation, T, EmiRecipe> mapper) {
        for (RecipeHolder<T> recipe : EmiIntegration.recipes(registry.getRecipeManager(), type)) {
            registry.addRecipe(mapper.apply(recipe.id(), (ResourceLocation)recipe.value()));
        }
    }

    private static Comparator<EmiRecipe> sortByInput() {
        return Comparator.comparingInt(r -> r.getInputs().size());
    }

    private static Comparator<EmiRecipe> basicSorter() {
        return (o1, o2) -> {
            if (o1 instanceof ComparableRecipe) {
                ComparableRecipe recipe = (ComparableRecipe)o1;
                return recipe.compareTo((EmiRecipe)o2);
            }
            return 0;
        };
    }
}

