/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.EmiIntegration;
import net.dries007.tfc.compat.emi.recipe.AutoLayoutRecipe;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class EmiAnvilRecipe
extends AutoLayoutRecipe<AnvilRecipe> {
    protected final int tier;

    public EmiAnvilRecipe(ResourceLocation id, AnvilRecipe recipe) {
        super(EmiIntegration.ANVIL, id, recipe);
        this.tier = recipe.getMinTier();
        this.init(recipe);
    }

    @Override
    protected void processRecipe(AnvilRecipe recipe) {
        this.inputs.add(EmiIngredient.of((Ingredient)recipe.getInput()));
        this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)EmiHelpers.registryAccess())));
    }

    @Override
    protected SlotWidget generateOutputSlot(EmiStack stack, int x, int y, int index) {
        return super.generateOutputSlot(stack, x, y, index).appendTooltip((Component)Component.translatable((String)"tfc.tooltip.anvil_tier_required", (Object[])new Object[]{Tooltips.tier(this.tier)}));
    }

    @Override
    public int compareTo(EmiRecipe other) {
        if (other instanceof EmiAnvilRecipe) {
            EmiAnvilRecipe r = (EmiAnvilRecipe)other;
            int tierDiff = this.tier - r.tier;
            if (tierDiff != 0) {
                return this.tier - r.tier;
            }
        }
        return super.compareTo(other);
    }
}

