/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.EmiIntegration;
import net.dries007.tfc.compat.emi.recipe.BasicRecipe;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector2i;

public class EmiBasePotRecipe<T extends PotRecipe>
extends BasicRecipe<T> {
    private final int duration;
    private final Vector2i[] SLOT_POSITIONS = new Vector2i[]{new Vector2i(24, 44), new Vector2i(15, 6), new Vector2i(33, 6), new Vector2i(6, 24), new Vector2i(24, 24), new Vector2i(42, 24)};

    public EmiBasePotRecipe(ResourceLocation id, T recipe, int width, int height) {
        super(EmiIntegration.POT, id, width, height);
        this.inputs.add(EmiHelpers.toIngredient(((PotRecipe)recipe).getFluidIngredient()));
        this.duration = ((PotRecipe)recipe).getDuration();
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addText((Component)Calendars.CLIENT.getTimeDelta(this.duration), this.getDisplayWidth() / 2, this.getDisplayHeight(), 0xFFFFFF, true).horizontalAlign(TextWidget.Alignment.CENTER).verticalAlign(TextWidget.Alignment.END);
        this.addInputWidgets(widgets);
        this.addOutputWidgets(widgets);
        widgets.addTexture(EmiTexture.EMPTY_FLAME, 68, 26);
        widgets.addAnimatedTexture(EmiTexture.FULL_FLAME, 68, 26, 8000, false, true, true);
    }

    protected void addInputWidgets(WidgetHolder widgets) {
        int index = 0;
        for (Vector2i pos : this.SLOT_POSITIONS) {
            if (index < this.inputs.size()) {
                widgets.addSlot((EmiIngredient)this.inputs.get(index), pos.x, pos.y);
            } else {
                widgets.addSlot(pos.x, pos.y);
            }
            ++index;
        }
    }

    protected void addOutputWidgets(WidgetHolder widgets) {
        int index = 0;
        for (Vector2i pos : this.outputSlotPositions()) {
            if (index < this.inputs.size()) {
                widgets.addSlot((EmiIngredient)this.outputs.get(index), pos.x, pos.y).recipeContext((EmiRecipe)this);
            } else {
                widgets.addSlot(pos.x, pos.y);
            }
            ++index;
        }
    }

    protected Vector2i[] outputSlotPositions() {
        int count = this.getOutputs().size();
        int distancePerStep = 20;
        int heightTotal = count * distancePerStep;
        int yOff = TextWidget.Alignment.CENTER.offset(heightTotal);
        ArrayList<Vector2i> points = new ArrayList<Vector2i>();
        for (int i = 0; i < count; ++i) {
            points.add(new Vector2i(90, 34 + yOff + distancePerStep * i));
        }
        return (Vector2i[])points.toArray(Vector2i[]::new);
    }

    protected static <T, V> List<V> groupSimilar(List<T> list, BiFunction<T, Integer, V> mapper, BiFunction<T, T, Boolean> comp) {
        ArrayList<T> ordered = new ArrayList<T>();
        HashMap<Object, Integer> stacked = new HashMap<Object, Integer>();
        for (T entry : list) {
            boolean found = false;
            Object target = entry;
            for (Object existing : ordered) {
                if (!comp.apply(existing, entry).booleanValue()) continue;
                found = true;
                target = existing;
                break;
            }
            if (!found) {
                ordered.add(entry);
            }
            stacked.compute(target, (x, i) -> i == null ? 1 : i + 1);
        }
        return ordered.stream().map(i -> mapper.apply(i, (Integer)stacked.get(i))).toList();
    }
}

