/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.player.ChiselMode;
import net.dries007.tfc.common.recipes.ChiselRecipe;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.EmiIntegration;
import net.dries007.tfc.compat.emi.recipe.BasicRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class EmiChiselRecipe
extends BasicRecipe<ChiselRecipe> {
    private final ChiselMode mode;

    public EmiChiselRecipe(ResourceLocation id, ChiselRecipe recipe) {
        super(EmiIntegration.CHISEL, id, 118, 26);
        this.mode = recipe.getMode();
        this.inputs.add(EmiHelpers.toIngredient(recipe.getIngredient()));
        this.inputs.add(EmiIngredient.of(TFCTags.Items.TOOLS_CHISEL));
        this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItem(null)));
        this.outputs.add(EmiStack.of((ItemStack)recipe.getItemOutput(ItemStack.EMPTY)));
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 6, 5);
        widgets.addSlot((EmiIngredient)this.inputs.get(1), 26, 5);
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 76, 5).recipeContext((EmiRecipe)this);
        widgets.addSlot((EmiIngredient)this.outputs.get(1), 96, 5).recipeContext((EmiRecipe)this);
        this.mode.createIcon((id, u, v, width, height) -> widgets.addTexture(id, 50, 3, width, height, u, v));
    }

    @Override
    public int compareTo(EmiRecipe other) {
        if (other instanceof EmiChiselRecipe) {
            EmiChiselRecipe chisel = (EmiChiselRecipe)other;
            ResourceLocation modeA = ChiselMode.REGISTRY.getKey((Object)this.mode);
            ResourceLocation modeB = ChiselMode.REGISTRY.getKey((Object)chisel.mode);
            return modeA.compareTo(modeB);
        }
        return super.compareTo(other);
    }
}

