/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.ButtonWidget;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.dries007.tfc.common.blocks.PouredGlassBlock;
import net.dries007.tfc.common.component.glass.GlassOperation;
import net.dries007.tfc.common.recipes.GlassworkingRecipe;
import net.dries007.tfc.compat.emi.EmiIntegration;
import net.dries007.tfc.compat.emi.recipe.BasicRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class EmiGlassworkingRecipe
extends BasicRecipe<GlassworkingRecipe> {
    private static final int OPERATIONS_PER_PAGE = 6;
    private final GlassworkingStepWidget[] stepWidgets;
    private final List<GlassOperation> operations;
    private int currentPage = 0;
    @Nullable
    private PageControlsWidget pageControls;

    public EmiGlassworkingRecipe(ResourceLocation id, GlassworkingRecipe recipe) {
        super(EmiIntegration.GLASSWORKING, id, 175, 30);
        BlockItem bi;
        this.inputs.add(EmiIngredient.of((Ingredient)recipe.batchItem()));
        this.operations = recipe.operations();
        for (GlassOperation operation : this.operations) {
            this.inputs.add(EmiIngredient.of(operation.getItems().stream().map(Holder::value).map(EmiStack::of).toList()));
        }
        ItemStack result = recipe.getResultItem(null);
        Item item = result.getItem();
        if (item instanceof BlockItem && (item = (bi = (BlockItem)item).getBlock()) instanceof PouredGlassBlock) {
            PouredGlassBlock block = (PouredGlassBlock)item;
            result = block.getDrop().getDefaultInstance();
        }
        this.outputs.add(EmiStack.of((ItemStack)result));
        int widgetCount = Math.min(this.operations.size(), 6);
        this.stepWidgets = new GlassworkingStepWidget[widgetCount];
        for (int i = 0; i < widgetCount; ++i) {
            this.stepWidgets[i] = new GlassworkingStepWidget(6, 30 + i * 20);
        }
        this.updateSteps();
        if (this.operations.size() > 6) {
            this.pageControls = new PageControlsWidget((Component)this.getLabelText(), 125, 20, this::hasPrevPage, this::prevStepPage, this::hasNextPage, this::nextStepPage);
        }
    }

    public int getDisplayHeight() {
        return this.stepWidgets[this.stepWidgets.length - 1].getBounds().bottom() + 4;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputs.getFirst(), 6, 6);
        widgets.addSlot((EmiIngredient)this.outputs.getFirst(), 56, 6).recipeContext((EmiRecipe)this);
        widgets.addFillingArrow(28, 7, 3000);
        if (this.pageControls != null) {
            widgets.add((Widget)this.pageControls);
            TextWidget label = widgets.addText((Component)Component.translatable((String)"tfc.tooltip.glass.title"), 125, 5, 0xFFFFFF, true);
            label.horizontalAlign(TextWidget.Alignment.CENTER).verticalAlign(TextWidget.Alignment.CENTER);
        }
        for (GlassworkingStepWidget step : this.stepWidgets) {
            widgets.add((Widget)step);
        }
    }

    private MutableComponent getLabelText() {
        int operationCount = this.operations.size();
        int currentSteps = Math.min(operationCount, (this.currentPage + 1) * 6);
        return Component.translatable((String)"tfc.tooltip.glass.step_count", (Object[])new Object[]{currentSteps, operationCount});
    }

    private void prevStepPage(double x, double y, int button) {
        if (this.hasPrevPage() && this.pageControls != null) {
            --this.currentPage;
            this.pageControls.updateText((Component)this.getLabelText());
            this.updateSteps();
            this.playClick();
        }
    }

    private void nextStepPage(double x, double y, int button) {
        if (this.hasNextPage() && this.pageControls != null) {
            ++this.currentPage;
            this.pageControls.updateText((Component)this.getLabelText());
            this.updateSteps();
            this.playClick();
        }
    }

    private boolean hasNextPage() {
        int viewedOperations = (this.currentPage + 1) * 6;
        return viewedOperations < this.operations.size();
    }

    private boolean hasPrevPage() {
        return this.currentPage > 0;
    }

    private void updateSteps() {
        int startingStep = this.currentPage * 6;
        int operationCount = this.operations.size();
        for (int i = 0; i < this.stepWidgets.length; ++i) {
            GlassworkingStepWidget widget = this.stepWidgets[i];
            int index = startingStep + i;
            if (index < operationCount) {
                widget.setOperation(this.operations.get(index), index);
                continue;
            }
            widget.setOperation(null, index);
        }
    }

    private void playClick() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    private static class GlassworkingStepWidget
    extends SlotWidget {
        private EmiIngredient displayStack;
        @Nullable
        private TextWidget label;

        public GlassworkingStepWidget(int x, int y) {
            super(null, x, y);
            this.setOperation(null, 0);
        }

        public EmiIngredient getStack() {
            return this.displayStack;
        }

        public void setOperation(@Nullable GlassOperation operation, int index) {
            if (operation == null) {
                this.label = null;
                this.displayStack = EmiStack.of((ItemStack)ItemStack.EMPTY);
            } else {
                MutableComponent labelText = Component.literal((String)(index + 1 + ". ")).append((Component)Component.translatable((String)operation.getTranslationId()));
                Bounds bounds = this.getBounds();
                int yOff = TextWidget.Alignment.CENTER.offset(bounds.height());
                this.label = new TextWidget(labelText.getVisualOrderText(), bounds.right() + 3, bounds.bottom() + yOff, 0xFFFFFF, true);
                this.label.verticalAlign(TextWidget.Alignment.CENTER);
                this.displayStack = EmiIngredient.of(operation.getItems().stream().map(Holder::value).map(EmiStack::of).toList());
            }
        }

        public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
            super.render(draw, mouseX, mouseY, delta);
            if (this.label != null) {
                this.label.render(draw, mouseX, mouseY, delta);
            }
        }
    }

    private static class PageControlsWidget
    extends Widget {
        private static final int BUTTON_SIZE = 12;
        private final int BUTTON_MARGIN = 6;
        private final int x;
        private final int y;
        private TextWidget text;
        @Nullable
        private SilentButtonWidget prevButton;
        @Nullable
        private SilentButtonWidget nextButton;
        private final BooleanSupplier checkPrev;
        private final ButtonWidget.ClickAction onPrev;
        private final BooleanSupplier checkNext;
        private final ButtonWidget.ClickAction onNext;

        public PageControlsWidget(Component text, int x, int y, BooleanSupplier checkPrev, ButtonWidget.ClickAction onPrev, BooleanSupplier checkNext, ButtonWidget.ClickAction onNext) {
            this.x = x;
            this.y = y;
            this.checkPrev = checkPrev;
            this.checkNext = checkNext;
            this.onPrev = onPrev;
            this.onNext = onNext;
            this.updateText(text);
        }

        public void updateText(Component text) {
            Bounds oldBounds = this.text != null ? this.text.getBounds() : null;
            this.text = new TextWidget(text.getVisualOrderText(), this.x, this.y, 0xFFFFFF, true);
            this.text.horizontalAlign(TextWidget.Alignment.CENTER);
            this.text.verticalAlign(TextWidget.Alignment.CENTER);
            Bounds textBounds = this.text.getBounds();
            if (!textBounds.equals((Object)oldBounds)) {
                int left = textBounds.left() - 12 - 6;
                int right = textBounds.right() + 6;
                int yPos = this.y - 6;
                this.prevButton = new SilentButtonWidget(left, yPos, 12, 12, 0, 0, this.checkPrev, this.onPrev);
                this.nextButton = new SilentButtonWidget(right, yPos, 12, 12, 12, 0, this.checkNext, this.onNext);
            }
        }

        public Bounds getBounds() {
            if (this.prevButton == null || this.nextButton == null) {
                return this.text.getBounds();
            }
            Bounds prevBounds = this.prevButton.getBounds();
            Bounds nextBounds = this.nextButton.getBounds();
            Bounds textBounds = this.text.getBounds();
            int height = Math.max(12, textBounds.height());
            int width = prevBounds.width() + 12 + textBounds.width() + nextBounds.width();
            return new Bounds(prevBounds.left(), prevBounds.top(), width, height);
        }

        public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
            this.text.render(draw, mouseX, mouseY, delta);
            if (this.prevButton != null) {
                this.prevButton.render(draw, mouseX, mouseY, delta);
            }
            if (this.nextButton != null) {
                this.nextButton.render(draw, mouseX, mouseY, delta);
            }
        }

        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            if (this.text.getBounds().contains(mouseX, mouseY)) {
                return this.text.mouseClicked(mouseX, mouseY, button);
            }
            if (this.prevButton != null && this.prevButton.getBounds().contains(mouseX, mouseY)) {
                return this.prevButton.mouseClicked(mouseX, mouseY, button);
            }
            if (this.nextButton != null && this.nextButton.getBounds().contains(mouseX, mouseY)) {
                return this.nextButton.mouseClicked(mouseX, mouseY, button);
            }
            return false;
        }
    }

    private static class SilentButtonWidget
    extends ButtonWidget {
        public SilentButtonWidget(int x, int y, int width, int height, int u, int v, BooleanSupplier isActive, ButtonWidget.ClickAction action) {
            super(x, y, width, height, u, v, isActive, action);
        }

        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            this.action.click((double)mouseX, (double)mouseY, button);
            return true;
        }
    }
}

