/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import net.dries007.tfc.common.recipes.InstantBarrelRecipe;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.EmiIntegration;
import net.dries007.tfc.compat.emi.recipe.AutoLayoutRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiSealedBarrelRecipe;
import net.dries007.tfc.compat.emi.stack.EmiSizedIngredient;
import net.dries007.tfc.compat.emi.widgets.CyclingSlotWidget;
import net.dries007.tfc.compat.emi.widgets.ItemStackProviderWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class EmiInstantBarrelRecipe
extends AutoLayoutRecipe<InstantBarrelRecipe> {
    private static final int SEED_UNIQUE = 0x8000000;
    private final boolean isStatic;
    private final ItemStackProvider outputProvider;
    @Nullable
    private SlotWidget itemInputSlot;

    public EmiInstantBarrelRecipe(ResourceLocation id, InstantBarrelRecipe recipe) {
        super(EmiIntegration.BARREL, id, recipe);
        this.outputProvider = recipe.getOutputItem();
        this.isStatic = !this.outputProvider.dependsOnInput();
        this.init(recipe);
    }

    @Override
    protected void processRecipe(InstantBarrelRecipe recipe) {
        ItemStack outputStack = this.outputProvider.getEmptyStack();
        SizedIngredient inputItem = recipe.getInputItem();
        FluidStack fluidOut = recipe.getOutputFluid();
        this.inputs.add(this.isStatic ? EmiIngredient.of((Ingredient)inputItem.ingredient()) : new EmiSizedIngredient(inputItem));
        this.inputs.add(EmiHelpers.toIngredient(recipe.getInputFluid()));
        if (!outputStack.isEmpty() || !this.isStatic) {
            this.outputs.add(EmiHelpers.nonDecayStack(outputStack));
        }
        if (!fluidOut.isEmpty()) {
            this.outputs.add(EmiStack.of((Fluid)fluidOut.getFluid(), (long)fluidOut.getAmount()));
        }
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        super.addWidgets(widgets);
        widgets.addText((Component)Component.translatable((String)"tfc.tooltip.barrel.instant"), this.getDisplayWidth() / 2, this.getDisplayHeight() - 2, -1, true).verticalAlign(TextWidget.Alignment.END).horizontalAlign(TextWidget.Alignment.CENTER);
    }

    @Override
    protected SlotWidget generateInputSlot(EmiIngredient ingredient, int x, int y, int index) {
        if (index == 0 && !this.isStatic) {
            this.itemInputSlot = new CyclingSlotWidget(ingredient, 0x8000000, x, y);
            return this.itemInputSlot;
        }
        return super.generateInputSlot(ingredient, x, y, index);
    }

    @Override
    protected SlotWidget generateOutputSlot(EmiStack stack, int x, int y, int index) {
        if (!this.isStatic && index == 0 && this.itemInputSlot != null) {
            return new ItemStackProviderWidget(this.itemInputSlot, this.outputProvider, 0x8000000, x, y);
        }
        return super.generateOutputSlot(stack, x, y, index);
    }

    @Override
    protected int getPaddingBottom() {
        return 10;
    }

    @Override
    public int compareTo(EmiRecipe other) {
        if (other instanceof EmiSealedBarrelRecipe) {
            return -1;
        }
        return super.compareTo(other);
    }

    public boolean supportsRecipeTree() {
        return this.isStatic;
    }
}

