/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import net.dries007.tfc.common.recipes.InstantFluidBarrelRecipe;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.EmiIntegration;
import net.dries007.tfc.compat.emi.recipe.AutoLayoutRecipe;
import net.dries007.tfc.compat.emi.recipe.EmiSealedBarrelRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class EmiInstantFluidBarrelRecipe
extends AutoLayoutRecipe<InstantFluidBarrelRecipe> {
    public EmiInstantFluidBarrelRecipe(ResourceLocation id, InstantFluidBarrelRecipe recipe) {
        super(EmiIntegration.BARREL, id, recipe);
        this.init(recipe);
    }

    @Override
    protected void processRecipe(InstantFluidBarrelRecipe recipe) {
        SizedFluidIngredient fluidA = recipe.getInputFluid();
        SizedFluidIngredient fluidB = recipe.getAddedFluid();
        FluidStack fluidOut = recipe.getOutputFluid();
        ItemStack itemOut = recipe.getResultItem();
        this.inputs.add(EmiHelpers.toIngredient(fluidA));
        this.inputs.add(EmiHelpers.toIngredient(fluidB));
        if (!itemOut.isEmpty()) {
            this.outputs.add(EmiStack.of((ItemStack)itemOut));
        }
        if (!fluidOut.isEmpty()) {
            this.outputs.add(EmiStack.of((Fluid)fluidOut.getFluid(), (long)fluidOut.getAmount()));
        }
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        super.addWidgets(widgets);
        widgets.addText((Component)Component.translatable((String)"tfc.tooltip.barrel.instant"), this.getDisplayWidth() / 2, this.getDisplayHeight() - 2, -1, true).verticalAlign(TextWidget.Alignment.END).horizontalAlign(TextWidget.Alignment.CENTER);
    }

    @Override
    protected int getPaddingBottom() {
        return 10;
    }

    @Override
    public int compareTo(EmiRecipe other) {
        if (other instanceof EmiSealedBarrelRecipe) {
            return -1;
        }
        return super.compareTo(other);
    }
}

