/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.FillingArrowWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.dries007.tfc.client.screen.KnappingScreen;
import net.dries007.tfc.common.recipes.KnappingRecipe;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.recipe.BasicRecipe;
import net.dries007.tfc.compat.emi.stack.EmiSizedIngredient;
import net.dries007.tfc.util.data.KnappingPattern;
import net.dries007.tfc.util.data.KnappingType;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

public class EmiKnappingRecipe
extends BasicRecipe<KnappingRecipe> {
    private final SizedIngredient inputItem;
    private final PatternWidget pattern;

    public EmiKnappingRecipe(EmiRecipeCategory category, ResourceLocation id, KnappingRecipe recipe) {
        super(category, id, 250, 250);
        this.inputItem = recipe.getIngredient() != null ? new SizedIngredient(recipe.getIngredient(), recipe.knappingType().get().inputItem().count()) : recipe.knappingType().get().inputItem();
        this.inputs.add(new EmiSizedIngredient(this.inputItem));
        this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)EmiHelpers.registryAccess())));
        this.pattern = new PatternWidget(recipe, recipe.getPattern(), this.inputItem.getItems(), 5, 5);
    }

    public int getDisplayHeight() {
        return this.pattern.getBounds().bottom() + 5;
    }

    public int getDisplayWidth() {
        return this.pattern.getBounds().right() + 56;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.add((Widget)this.pattern);
        Bounds bounds = this.pattern.getBounds();
        int height = bounds.y() - TextWidget.Alignment.CENTER.offset(bounds.height());
        FillingArrowWidget arrow = widgets.addFillingArrow(bounds.right() + 4, height - 8, 3000);
        widgets.addSlot((EmiIngredient)this.outputs.getFirst(), arrow.getBounds().right() + 4, height - 9).recipeContext((EmiRecipe)this);
    }

    private static class PatternWidget
    extends Widget {
        private static final int INCREMENT = 1000;
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final KnappingPattern pattern;
        private final KnappingType knappingType;
        private final ItemStack[] stacks;
        @Nullable
        private ItemStack displayStack;
        @Nullable
        private ResourceLocation high;
        @Nullable
        private ResourceLocation low;
        private long lastGenerate = 0L;
        private int displayIndex;

        public PatternWidget(KnappingRecipe recipe, KnappingPattern pattern, ItemStack[] input, int x, int y) {
            this.x = x;
            this.y = y;
            this.width = pattern.getWidth();
            this.height = pattern.getHeight();
            this.pattern = pattern;
            this.stacks = input;
            this.knappingType = recipe.knappingType().get();
        }

        public Bounds getBounds() {
            return new Bounds(this.x, this.y, this.width * 16, this.height * 16);
        }

        private void cycleTextures() {
            long time = System.currentTimeMillis() / 1000L;
            if (this.displayStack == null || time > this.lastGenerate) {
                this.lastGenerate = time;
                if (this.displayStack != null && Screen.hasShiftDown()) {
                    return;
                }
                this.displayIndex = (this.displayIndex + 1) % this.stacks.length;
                this.displayStack = this.stacks[this.displayIndex];
                this.high = KnappingScreen.getHighTexture(this.displayStack);
                this.low = KnappingScreen.getLowTexture(this.knappingType, this.displayStack);
            }
        }

        public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
            this.cycleTextures();
            draw.fill(this.x - 1, this.y - 1, this.x + this.width * 16 + 1, this.y + this.height * 16 + 1, -5592406);
            for (int xi = 0; xi < this.width; ++xi) {
                for (int yi = 0; yi < this.height; ++yi) {
                    int xp = this.x + 16 * xi;
                    int yp = this.y + 16 * yi;
                    if (this.pattern.get(xi, yi) && xi < this.pattern.getWidth() && yi < this.pattern.getHeight()) {
                        this.drawTex(this.high, draw, xp, yp);
                        continue;
                    }
                    this.drawTex(this.low, draw, xp, yp);
                }
            }
        }

        private void drawTex(@Nullable ResourceLocation location, GuiGraphics draw, int xp, int yp) {
            if (location != null) {
                draw.blit(location, xp, yp, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }

        public List<ClientTooltipComponent> getTooltip(int mouseX, int mouseY) {
            ArrayList<ClientTooltipComponent> lines = new ArrayList<ClientTooltipComponent>();
            if (this.displayStack != null) {
                List display = this.displayStack.getTooltipLines(Item.TooltipContext.EMPTY, null, (TooltipFlag)TooltipFlag.NORMAL);
                lines.addAll(display.stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).toList());
                lines.add(new StackTooltip(this.displayStack));
            }
            return lines;
        }

        public boolean mouseClicked(int mouseX, int mouseY, int button) {
            if (this.displayStack == null) {
                return true;
            }
            if (button == 0) {
                EmiApi.displayRecipes((EmiIngredient)EmiStack.of((ItemStack)this.displayStack));
            } else if (button == 1) {
                EmiApi.displayUses((EmiIngredient)EmiStack.of((ItemStack)this.displayStack));
            }
            return true;
        }
    }

    private record StackTooltip(ItemStack stack) implements ClientTooltipComponent
    {
        public int getHeight() {
            return 18;
        }

        public int getWidth(Font font) {
            return 18;
        }

        public void renderImage(Font font, int x, int y, GuiGraphics draw) {
            draw.renderItem(this.stack, x, y);
            String amount = String.valueOf(this.stack.getCount());
            int xp = x + this.getWidth(font) - Math.min(14, font.width(amount));
            int n = y + this.getHeight();
            Objects.requireNonNull(font);
            int yp = n - 9;
            draw.pose().pushPose();
            draw.pose().translate(0.0f, 0.0f, 300.0f);
            draw.drawString(font, amount, xp, yp, -1, true);
            draw.pose().popPose();
        }
    }
}

