/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.FillingArrowWidget;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.dries007.tfc.common.recipes.SealedBarrelRecipe;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.EmiIntegration;
import net.dries007.tfc.compat.emi.recipe.AutoLayoutRecipe;
import net.dries007.tfc.compat.emi.stack.EmiSizedIngredient;
import net.dries007.tfc.compat.emi.widgets.CyclingSlotWidget;
import net.dries007.tfc.compat.emi.widgets.ItemStackProviderWidget;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class EmiSealedBarrelRecipe
extends AutoLayoutRecipe<SealedBarrelRecipe> {
    private static final int SEED_UNIQUE = 0x1000000;
    private final boolean infinite;
    private final int duration;
    @Nullable
    private ItemStackProvider outputProvider;
    @Nullable
    private ItemStackProvider onSeal;
    @Nullable
    private ItemStackProvider onUnseal;

    public EmiSealedBarrelRecipe(ResourceLocation id, SealedBarrelRecipe recipe) {
        super(EmiIntegration.BARREL, id, recipe);
        this.infinite = recipe.isInfinite();
        this.duration = recipe.getDuration();
        this.init(recipe);
    }

    @Override
    protected void processRecipe(SealedBarrelRecipe recipe) {
        this.onSeal = recipe.onSeal();
        this.onUnseal = recipe.onUnseal();
        SizedIngredient input = recipe.getInputItem();
        ItemStackProvider output = recipe.getOutputItem();
        boolean isStatic = !output.dependsOnInput() && this.onSeal == null && this.onUnseal == null;
        this.inputs.add(isStatic ? EmiIngredient.of((Ingredient)input.ingredient(), (long)input.count()) : new EmiSizedIngredient(input));
        this.inputs.add(EmiHelpers.toIngredient(recipe.getInputFluid()));
        if (output.dependsOnInput()) {
            this.outputProvider = output;
        } else {
            ItemStack stack = output.stack();
            if (!stack.isEmpty()) {
                this.outputs.add(EmiHelpers.nonDecayStack(stack));
            }
        }
        FluidStack fluid = recipe.getOutputFluid();
        if (!fluid.isEmpty()) {
            this.outputs.add(EmiStack.of((Fluid)fluid.getFluid(), (long)fluid.getAmount()));
        }
    }

    @Override
    protected List<Widget> generateWidgets(SealedBarrelRecipe recipe) {
        int y = this.getMargin() + this.getPaddingTop();
        AutoLayoutRecipe.WidgetLayout widgets = new AutoLayoutRecipe.WidgetLayout(new Bounds(this.getMargin() + this.getPaddingLeft(), this.getMargin() + this.getPaddingTop(), 0, 0));
        SlotWidget itemInputSlot = this.makeItemInputSlot(widgets.last(AutoLayoutRecipe.Position.RIGHT), y);
        if (itemInputSlot != null) {
            widgets.add(itemInputSlot);
        }
        widgets.add(new SlotWidget((EmiIngredient)this.inputs.getLast(), widgets.last(AutoLayoutRecipe.Position.RIGHT, 3), y));
        widgets.add(new FillingArrowWidget(widgets.last(AutoLayoutRecipe.Position.RIGHT, 3), y, 3000));
        SlotWidget sealSlot = null;
        if (itemInputSlot != null) {
            if (this.onSeal != null) {
                sealSlot = widgets.addWidget(new ItemStackProviderWidget(itemInputSlot, this.onSeal, 0x1000000, widgets.last(AutoLayoutRecipe.Position.RIGHT, 3), y).recipeContext(this).appendTooltip((Component)Component.translatable((String)"tfc.tooltip.while_sealed_description")));
                widgets.add(new FillingArrowWidget(widgets.last(AutoLayoutRecipe.Position.RIGHT, 3), y, 3000));
            }
            if (this.outputProvider != null) {
                widgets.add(new ItemStackProviderWidget(itemInputSlot, this.outputProvider, 0x1000000, widgets.last(AutoLayoutRecipe.Position.RIGHT, 3), y).recipeContext(this));
            }
            if (this.onUnseal != null) {
                widgets.add(new ItemStackProviderWidget(sealSlot != null ? sealSlot : itemInputSlot, this.onUnseal, 0x1000000, widgets.last(AutoLayoutRecipe.Position.RIGHT, 3), y).recipeContext(this));
            }
        }
        for (EmiStack out : this.outputs) {
            widgets.add(new SlotWidget((EmiIngredient)out, widgets.last(AutoLayoutRecipe.Position.RIGHT, 3), y).recipeContext((EmiRecipe)this));
        }
        return widgets;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        super.addWidgets(widgets);
        widgets.addText((Component)this.getTimeText(), this.getDisplayWidth() / 2, this.getDisplayHeight() - 2, -1, true).verticalAlign(TextWidget.Alignment.END).horizontalAlign(TextWidget.Alignment.CENTER);
    }

    private MutableComponent getTimeText() {
        if (this.infinite) {
            return Component.translatable((String)"tfc.tooltip.barrel.infinite");
        }
        return Calendars.CLIENT.getTimeDelta(this.duration);
    }

    @Override
    protected int getPaddingBottom() {
        return 10;
    }

    public boolean supportsRecipeTree() {
        return this.outputProvider == null && super.supportsRecipeTree();
    }

    @Nullable
    private SlotWidget makeItemInputSlot(int x, int y) {
        EmiIngredient ingredient = (EmiIngredient)this.inputs.getFirst();
        if (ingredient.getEmiStacks().size() > 1 && (this.onSeal != null || this.outputProvider != null)) {
            return new CyclingSlotWidget(ingredient, 0x1000000, x, y);
        }
        if (ingredient.isEmpty()) {
            return null;
        }
        return new SlotWidget(ingredient, x, y);
    }

    @Override
    public int compareTo(EmiRecipe other) {
        if (other instanceof EmiSealedBarrelRecipe) {
            EmiSealedBarrelRecipe recipe = (EmiSealedBarrelRecipe)other;
            if (this.infinite != recipe.infinite) {
                return this.infinite ? 1 : -1;
            }
            int durationDiff = this.duration - recipe.duration;
            if (durationDiff != 0) {
                return durationDiff;
            }
            return super.compareTo(recipe);
        }
        return 1;
    }
}

