/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.dries007.tfc.common.recipes.SimplePotRecipe;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.recipe.EmiBasePotRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class EmiSimplePotRecipe
extends EmiBasePotRecipe<SimplePotRecipe> {
    public EmiSimplePotRecipe(ResourceLocation id, SimplePotRecipe recipe) {
        super(id, recipe, 113, 80);
        List<Ingredient> ing = recipe.getItemIngredients();
        this.inputs.addAll(EmiSimplePotRecipe.groupSimilar(ing, EmiIngredient::of, Objects::equals));
        ArrayList<ItemStack> unsortedStacks = new ArrayList<ItemStack>();
        int j = 0;
        for (ItemStackProvider provider : recipe.getOutputItems()) {
            List<ItemStack> stacks = EmiHelpers.collapse(provider, ing.get(j));
            for (ItemStack stack : stacks) {
                if (stack.isEmpty()) continue;
                unsortedStacks.add(stack);
            }
        }
        this.outputs.addAll(EmiSimplePotRecipe.groupSimilar(unsortedStacks, EmiSimplePotRecipe::toStack, ItemStack::matches));
        FluidStack fluidOut = recipe.getDisplayFluid();
        if (!fluidOut.isEmpty()) {
            this.outputs.add(EmiStack.of((Fluid)fluidOut.getFluid(), (long)fluidOut.getAmount()));
        }
    }

    private static EmiStack toStack(ItemStack stack, int size) {
        return EmiStack.of((ItemStack)EmiHelpers.setDefaultNonDecay(stack), (long)size);
    }
}

