/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.recipes.WeldingRecipe;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.dries007.tfc.compat.emi.EmiIntegration;
import net.dries007.tfc.compat.emi.recipe.AutoLayoutRecipe;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class EmiWeldingRecipe
extends AutoLayoutRecipe<WeldingRecipe> {
    private final int tier;

    public EmiWeldingRecipe(ResourceLocation id, WeldingRecipe recipe) {
        super(EmiIntegration.WELDING, id, recipe);
        this.tier = recipe.getTier();
        this.init(recipe);
    }

    @Override
    protected void processRecipe(WeldingRecipe recipe) {
        this.inputs.add(EmiIngredient.of((Ingredient)recipe.getFirstInput()));
        this.inputs.add(EmiIngredient.of((Ingredient)recipe.getSecondInput()));
        this.inputs.add(EmiIngredient.of(TFCTags.Items.WELDING_FLUX));
        this.outputs.add(EmiStack.of((ItemStack)recipe.getResultItem((HolderLookup.Provider)EmiHelpers.registryAccess())));
    }

    @Override
    protected SlotWidget generateOutputSlot(EmiStack stack, int x, int y, int index) {
        return super.generateOutputSlot(stack, x, y, index).appendTooltip((Component)Component.translatable((String)"tfc.tooltip.anvil_tier_required", (Object[])new Object[]{Tooltips.tier(this.tier)}));
    }

    @Override
    public int compareTo(EmiRecipe other) {
        if (other instanceof EmiWeldingRecipe) {
            EmiWeldingRecipe r = (EmiWeldingRecipe)other;
            int tierDiff = this.tier - r.tier;
            if (tierDiff != 0) {
                return this.tier - r.tier;
            }
        }
        return super.compareTo(other);
    }
}

