/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.emi.stack;

import com.google.common.collect.Lists;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dries007.tfc.compat.emi.EmiHelpers;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class EmiSizedIngredient
implements EmiIngredient {
    private final List<EmiStack> stacks;
    private long amount;
    private float chance = 1.0f;

    public EmiSizedIngredient(SizedIngredient ingredient) {
        this.amount = ingredient.count();
        this.stacks = Arrays.stream(ingredient.getItems()).map(EmiHelpers::nonDecayStack).toList();
    }

    public EmiSizedIngredient(List<EmiStack> stack, long amount) {
        this.amount = amount;
        this.stacks = List.copyOf(stack);
    }

    public List<EmiStack> getEmiStacks() {
        return this.stacks;
    }

    public EmiIngredient copy() {
        return new EmiSizedIngredient(this.stacks, this.amount).setChance(this.chance);
    }

    public long getAmount() {
        return this.amount;
    }

    public EmiIngredient setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    public float getChance() {
        return this.chance;
    }

    public EmiIngredient setChance(float chance) {
        this.chance = chance;
        return this;
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        if (this.stacks.isEmpty()) {
            return;
        }
        int item = (int)(System.currentTimeMillis() / 1000L % (long)this.stacks.size());
        this.stacks.get(item).render(draw, x, y, delta, flags);
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList tooltip = Lists.newArrayList();
        int item = (int)(System.currentTimeMillis() / 1000L % (long)this.stacks.size());
        tooltip.addAll(this.stacks.get(item).copy().setAmount(this.amount).getTooltip());
        return tooltip;
    }
}

