/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import java.awt.Color;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.common.blocks.PouredGlassBlock;
import net.dries007.tfc.common.component.glass.GlassOperation;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.GlassworkingRecipe;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GlassworkingRecipeCategory
extends BaseRecipeCategory<GlassworkingRecipe> {
    public GlassworkingRecipeCategory(RecipeType<GlassworkingRecipe> type, IGuiHelper helper) {
        super(type, helper, 175, 110, new ItemStack((ItemLike)TFCItems.BLOWPIPE_WITH_GLASS.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GlassworkingRecipe recipe, IFocusGroup focuses) {
        BlockItem bi;
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 6, 5).addIngredients(recipe.batchItem())).setBackground((IDrawable)this.slot, -1, -1);
        ItemStack result = recipe.getResultItem(null);
        Item item = result.getItem();
        if (item instanceof BlockItem && (item = (bi = (BlockItem)item).getBlock()) instanceof PouredGlassBlock) {
            PouredGlassBlock block = (PouredGlassBlock)item;
            result = block.getDrop().getDefaultInstance();
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 5).addItemStack(result)).setBackground((IDrawable)this.slot, -1, -1);
        int idx = 0;
        for (GlassOperation operation : recipe.operations()) {
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.CATALYST, idx < 3 ? 6 : 90, 25 * (idx % 3 + 1)).setBackground((IDrawable)this.slot, -1, -1);
            for (Holder<Item> item2 : operation.getItems()) {
                slot.addItemStack(((Item)item2.value()).getDefaultInstance());
            }
            ++idx;
        }
    }

    public void draw(GlassworkingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.arrow.draw(graphics, 92, 5);
        this.arrowAnimated.draw(graphics, 92, 5);
        Font font = Minecraft.getInstance().font;
        int idx = 0;
        for (GlassOperation operation : recipe.operations()) {
            MutableComponent text = Component.literal((String)(idx + 1 + ". ")).append((Component)Component.translatable((String)operation.getTranslationId()));
            if (idx + 3 < recipe.operations().size()) {
                graphics.drawWordWrap(font, (FormattedText)text, (idx < 3 ? 6 : 90) + 20, 25 * (idx % 3 + 1) + 5, idx < 3 ? 55 : 75, Color.BLACK.getRGB());
            } else {
                graphics.drawString(font, (Component)text, (idx < 3 ? 6 : 90) + 20, 25 * (idx % 3 + 1) + 5, Color.BLACK.getRGB(), false);
            }
            ++idx;
        }
    }
}

