/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.recipes.SealedBarrelRecipe;
import net.dries007.tfc.compat.jei.category.BarrelRecipeCategory;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class SealedBarrelRecipeCategory
extends BarrelRecipeCategory<SealedBarrelRecipe> {
    public SealedBarrelRecipeCategory(RecipeType<SealedBarrelRecipe> type, IGuiHelper helper) {
        super(type, helper, 148, 32, Wood.MAPLE);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, SealedBarrelRecipe recipe, IFocusGroup focuses) {
        super.setRecipe(builder, recipe, focuses);
        if (recipe.onSeal() != null) {
            List<ItemStack> inputItem = SealedBarrelRecipeCategory.collapse(recipe.getInputItem());
            List<ItemStack> intermediateItem = SealedBarrelRecipeCategory.collapse(inputItem, recipe.onSeal());
            List<ItemStack> outputItem = SealedBarrelRecipeCategory.collapse(inputItem, recipe.getOutputItem());
            IRecipeSlotBuilder intermediateSlot = builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 76, 5);
            intermediateSlot.addItemStacks(intermediateItem);
            intermediateSlot.addRichTooltipCallback((slots, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"tfc.tooltip.while_sealed_description").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC})));
            intermediateSlot.setBackground((IDrawable)this.slot, -1, -1);
            if ((outputItem.isEmpty() || outputItem.stream().allMatch(ItemStack::isEmpty)) && recipe.onUnseal() != null) {
                if (this.outputItemSlot == null) {
                    int[] positions = this.slotPositions(recipe);
                    FluidStack outputFluid = recipe.getOutputFluid();
                    this.outputItemSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, outputFluid.isEmpty() ? positions[2] : positions[3], 5);
                }
                List<ItemStack> outputFromIntermediate = SealedBarrelRecipeCategory.collapse(intermediateItem, recipe.onUnseal());
                this.outputItemSlot.addItemStacks(outputFromIntermediate);
                this.outputItemSlot.setBackground((IDrawable)this.slot, -1, -1);
            }
            if (recipe.onSeal().dependsOnInput() && this.inputItemSlot != null && this.outputItemSlot != null) {
                builder.createFocusLink(new IIngredientAcceptor[]{intermediateSlot, this.inputItemSlot, this.outputItemSlot});
            }
        }
    }

    @Override
    public void draw(SealedBarrelRecipe recipe, IRecipeSlotsView recipeSlots, GuiGraphics stack, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlots, stack, mouseX, mouseY);
        if (recipe.onSeal() != null) {
            this.arrow.draw(stack, 98, 5);
            this.arrowAnimated.draw(stack, 98, 5);
        }
        MutableComponent text = (recipe.isInfinite() ? Component.translatable((String)"tfc.tooltip.while_sealed") : Calendars.CLIENT.getTimeDelta(recipe.getDuration())).withStyle(ChatFormatting.BLACK);
        Font font = Minecraft.getInstance().font;
        stack.drawString(font, (Component)text, 74 - font.width((FormattedText)text) / 2, 24, 0xFFFFFF, false);
    }

    @Override
    protected int arrowPosition(SealedBarrelRecipe recipe) {
        return recipe.onSeal() != null ? super.arrowPosition(recipe) : 63;
    }

    @Override
    protected int[] slotPositions(SealedBarrelRecipe recipe) {
        int[] nArray;
        if (recipe.onSeal() != null) {
            int[] nArray2 = new int[4];
            nArray2[0] = 6;
            nArray2[1] = 26;
            nArray2[2] = 125;
            nArray = nArray2;
            nArray2[3] = 96;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = 21;
            nArray3[1] = 41;
            nArray3[2] = 91;
            nArray = nArray3;
            nArray3[3] = 111;
        }
        return nArray;
    }
}

