/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.common.recipes.ItemRecipe;
import net.dries007.tfc.compat.jei.JEIIntegration;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleItemRecipeCategory<T extends ItemRecipe>
extends BaseRecipeCategory<T> {
    public SimpleItemRecipeCategory(RecipeType<T> type, IGuiHelper helper, ItemStack icon) {
        super(type, helper, 98, 26, icon);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 6, 5);
        inputSlot.setBackground((IDrawable)this.slot, -1, -1);
        IRecipeSlotBuilder toolSlot = null;
        if (this.getToolTag() != null) {
            toolSlot = builder.addSlot(RecipeIngredientRole.CATALYST, 26, 5);
        }
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 5);
        Ingredient ingredient = ((ItemRecipe)recipe).getIngredient();
        List<ItemStack> inputList = List.of(ingredient.getItems());
        inputSlot.addIngredients(JEIIntegration.ITEM_STACK, inputList);
        if (toolSlot != null) {
            toolSlot.addIngredients(Ingredient.of(this.getToolTag()));
            toolSlot.setBackground((IDrawable)this.slot, -1, -1);
        }
        outputSlot.addItemStacks(SimpleItemRecipeCategory.collapse(inputList, ((ItemRecipe)recipe).getResult()));
        outputSlot.setBackground((IDrawable)this.slot, -1, -1);
        if (!this.addItemsToOutputSlot(recipe, outputSlot, inputList)) {
            builder.createFocusLink(new IIngredientAcceptor[]{inputSlot, outputSlot});
        }
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlots, GuiGraphics stack, double mouseX, double mouseY) {
        this.arrow.draw(stack, this.getToolTag() == null ? 36 : 48, 5);
        this.arrowAnimated.draw(stack, this.getToolTag() == null ? 36 : 48, 5);
    }

    protected boolean addItemsToOutputSlot(T recipe, IRecipeSlotBuilder output, List<ItemStack> inputs) {
        return false;
    }

    @Nullable
    protected abstract TagKey<Item> getToolTag();
}

