/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.transfer;

import java.util.Optional;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.container.PotContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.compat.jei.transfer.BaseTransferInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public class PotTransferInfo
extends BaseTransferInfo<PotContainer, PotRecipe>
implements IRecipeTransferInfo<PotContainer, PotRecipe> {
    private final IRecipeTransferHandlerHelper transferHelper;

    public PotTransferInfo(IRecipeTransferHandlerHelper transferHelper, RecipeType<PotRecipe> recipeType) {
        super(PotContainer.class, Optional.of((MenuType)TFCContainerTypes.POT.get()), recipeType, 9, 4, 5, 6, 7, 8);
        this.transferHelper = transferHelper;
    }

    public boolean canHandle(PotContainer container, PotRecipe recipe) {
        if (((PotBlockEntity)container.getBlockEntity()).hasRecipeStarted()) {
            return false;
        }
        PotBlockEntity.PotInventory inventory = (PotBlockEntity.PotInventory)((PotBlockEntity)container.getBlockEntity()).getInventory();
        return recipe.getFluidIngredient().test(inventory.getFluidInTank(0));
    }

    @Nullable
    public IRecipeTransferError getHandlingError(PotContainer container, PotRecipe recipe) {
        PotBlockEntity.PotInventory inventory = (PotBlockEntity.PotInventory)((PotBlockEntity)container.getBlockEntity()).getInventory();
        SizedFluidIngredient fluidIngredient = recipe.getFluidIngredient();
        FluidStack fluidInTank = inventory.getFluidInTank(0);
        if (!fluidIngredient.ingredient().test(fluidInTank)) {
            return this.transferHelper.createUserErrorWithTooltip((Component)Component.translatable((String)"tfc.jei.transfer.error.pot_wrong_fluid", (Object[])new Object[]{fluidInTank.getHoverName().getString()}));
        }
        if (fluidInTank.getAmount() < fluidIngredient.amount()) {
            int missingFluid = fluidIngredient.amount() - fluidInTank.getAmount();
            return this.transferHelper.createUserErrorWithTooltip((Component)Component.translatable((String)"tfc.jei.transfer.error.pot_not_enough_fluid", (Object[])new Object[]{missingFluid, fluidInTank.getHoverName().getString()}));
        }
        return this.transferHelper.createUserErrorWithTooltip((Component)Component.translatable((String)"tfc.jei.transfer.error.pot_started"));
    }
}

