/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin.client.compat.patchouli;

import java.util.Objects;
import net.dries007.tfc.client.screen.button.PlayerInventoryTabButton;
import net.dries007.tfc.network.SwitchInventoryTabPacket;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.book.Book;

@Mixin(value={GuiBook.class})
public abstract class GuiBookMixin
extends Screen {
    @Shadow
    public int bookLeft;
    @Shadow
    public int bookTop;
    @Shadow
    public final Book book;

    @Shadow
    public abstract Minecraft getMinecraft();

    protected GuiBookMixin(Component title, Book book) {
        super(title);
        this.book = book;
    }

    @Inject(method={"init"}, at={@At(value="TAIL")}, cancellable=false)
    public void injectTabButtons(CallbackInfo ci) {
        if (this.book.id.equals((Object)Helpers.resourceLocation("tfc", "field_guide"))) {
            Inventory playerInventory = Objects.requireNonNull(this.getMinecraft().player).getInventory();
            this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.bookLeft, this.bookTop, false, true, PlayerInventoryTabButton.Tab.INVENTORY, button -> {
                playerInventory.player.containerMenu = playerInventory.player.inventoryMenu;
                Minecraft.getInstance().setScreen((Screen)new InventoryScreen(playerInventory.player));
                PacketDistributor.sendToServer((CustomPacketPayload)new SwitchInventoryTabPacket(PlayerInventoryTabButton.Tab.INVENTORY), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }));
            this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.bookLeft, this.bookTop, false, true, PlayerInventoryTabButton.Tab.CALENDAR));
            this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.bookLeft, this.bookTop, false, true, PlayerInventoryTabButton.Tab.NUTRITION));
            this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.bookLeft, this.bookTop, false, true, PlayerInventoryTabButton.Tab.CLIMATE));
            this.addRenderableWidget((GuiEventListener)new PlayerInventoryTabButton(this.bookLeft, this.bookTop, true, true, PlayerInventoryTabButton.Tab.BOOK));
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=false)
    public void injectRenderConsistentBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        if (this.book.id.equals((Object)Helpers.resourceLocation("tfc", "field_guide"))) {
            graphics.pose().pushPose();
            graphics.pose().scale(8.0f, 8.0f, 1.0f);
            this.renderTransparentBackground(graphics);
            graphics.pose().popPose();
        }
    }
}

