/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.util.data.DataManager;
import net.dries007.tfc.util.data.DataManagers;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public record DataManagerSyncPacket(List<Entry<?>> values) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DataManagerSyncPacket> TYPE = PacketHandler.type("data_managers");
    public static final StreamCodec<RegistryFriendlyByteBuf, DataManagerSyncPacket> CODEC = ByteBufCodecs.registry(DataManagers.KEY).dispatch(Entry::manager, DataManagerSyncPacket::streamCodec).apply(ByteBufCodecs.list()).map(DataManagerSyncPacket::new, DataManagerSyncPacket::values);
    private static final Logger LOGGER = LogUtils.getLogger();

    public DataManagerSyncPacket() {
        this(DataManagers.REGISTRY.stream().filter(DataManager::isSynced).map(Entry::new).toList());
    }

    private static <T> StreamCodec<RegistryFriendlyByteBuf, Entry<T>> streamCodec(DataManager<T> manager) {
        return ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, manager.streamCodec()).map(e -> new Entry(manager, e), e -> e.values);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    void handle(boolean isMemoryConnection) {
        if (isMemoryConnection) {
            LOGGER.info("Ignoring DataManager sync on logical server");
            return;
        }
        for (Entry<?> v : this.values) {
            v.handle();
        }
    }

    record Entry<T>(DataManager<T> manager, Map<ResourceLocation, T> values) {
        Entry(DataManager<T> manager) {
            this(manager, manager.getElements());
        }

        void handle() {
            this.manager.bindValues(this.values);
        }
    }
}

