/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.dries007.tfc.network.CalendarUpdatePacket;
import net.dries007.tfc.network.ChunkWatchPacket;
import net.dries007.tfc.network.CycleChiselModePacket;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.network.EffectExpirePacket;
import net.dries007.tfc.network.OpenFieldGuidePacket;
import net.dries007.tfc.network.PetCommandPacket;
import net.dries007.tfc.network.PlaceBlockSpecialPacket;
import net.dries007.tfc.network.PlayerDrinkPacket;
import net.dries007.tfc.network.PlayerInfoPacket;
import net.dries007.tfc.network.PourFasterPacket;
import net.dries007.tfc.network.ProspectedPacket;
import net.dries007.tfc.network.RequestClimateModelPacket;
import net.dries007.tfc.network.ScreenButtonPacket;
import net.dries007.tfc.network.ScribingTablePacket;
import net.dries007.tfc.network.SelectAnvilPlanPacket;
import net.dries007.tfc.network.StackFoodPacket;
import net.dries007.tfc.network.SwitchInventoryTabPacket;
import net.dries007.tfc.network.UpdateClimateModelPacket;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public final class PacketHandler {
    public static <T extends CustomPacketPayload> CustomPacketPayload.Type<T> type(String id) {
        return new CustomPacketPayload.Type(Helpers.identifier(id));
    }

    public static void setup(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar register = event.registrar(ModList.get().getModFileById("tfc").versionString());
        register.playToClient(ChunkWatchPacket.TYPE, ChunkWatchPacket.CODEC, PacketHandler.onClient(ChunkWatchPacket::handle));
        register.playToClient(CalendarUpdatePacket.TYPE, CalendarUpdatePacket.CODEC, PacketHandler.onClient(CalendarUpdatePacket::handle));
        register.playToClient(PlayerInfoPacket.TYPE, PlayerInfoPacket.CODEC, PacketHandler.onClient(PlayerInfoPacket::handle));
        register.playToClient(ProspectedPacket.TYPE, ProspectedPacket.CODEC, PacketHandler.onClient(ProspectedPacket::handle));
        register.playToClient(EffectExpirePacket.TYPE, EffectExpirePacket.CODEC, PacketHandler.onClient(EffectExpirePacket::handle));
        register.playToClient(UpdateClimateModelPacket.TYPE, UpdateClimateModelPacket.CODEC, PacketHandler.onClient(UpdateClimateModelPacket::handle));
        register.playToClient(DataManagerSyncPacket.TYPE, DataManagerSyncPacket.CODEC, (packet, context) -> context.enqueueWork(() -> packet.handle(context.connection().isMemoryConnection())));
        register.playToServer(SwitchInventoryTabPacket.TYPE, SwitchInventoryTabPacket.CODEC, PacketHandler.onServer(SwitchInventoryTabPacket::handle));
        register.playToServer(PlaceBlockSpecialPacket.TYPE, PlaceBlockSpecialPacket.CODEC, PacketHandler.onServer(PlaceBlockSpecialPacket::handle));
        register.playToServer(CycleChiselModePacket.TYPE, CycleChiselModePacket.CODEC, PacketHandler.onServer(CycleChiselModePacket::handle));
        register.playToServer(ScreenButtonPacket.TYPE, ScreenButtonPacket.CODEC, PacketHandler.onServer(ScreenButtonPacket::handle));
        register.playToServer(PlayerDrinkPacket.TYPE, PlayerDrinkPacket.CODEC, PacketHandler.onServer(PlayerDrinkPacket::handle));
        register.playToServer(RequestClimateModelPacket.TYPE, RequestClimateModelPacket.CODEC, PacketHandler.onServer(RequestClimateModelPacket::handle));
        register.playToServer(ScribingTablePacket.TYPE, ScribingTablePacket.CODEC, PacketHandler.onServer(ScribingTablePacket::handle));
        register.playToServer(StackFoodPacket.TYPE, StackFoodPacket.CODEC, PacketHandler.onServer(StackFoodPacket::handle));
        register.playToServer(OpenFieldGuidePacket.TYPE, OpenFieldGuidePacket.CODEC, PacketHandler.onServer(OpenFieldGuidePacket::handle));
        register.playToServer(PetCommandPacket.TYPE, PetCommandPacket.CODEC, PacketHandler.onServer(PetCommandPacket::handle));
        register.playToServer(PourFasterPacket.TYPE, PourFasterPacket.CODEC, PacketHandler.onServer(PourFasterPacket::handle));
        register.playToServer(SelectAnvilPlanPacket.TYPE, SelectAnvilPlanPacket.CODEC, PacketHandler.onServer(SelectAnvilPlanPacket::handle));
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> onClient(Consumer<T> handler) {
        return (payload, context) -> context.enqueueWork(() -> handler.accept(payload));
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> onServer(BiConsumer<T, ServerPlayer> handler) {
        return (payload, context) -> context.enqueueWork(() -> handler.accept(payload, (ServerPlayer)context.player()));
    }
}

