/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import io.netty.buffer.ByteBuf;
import net.dries007.tfc.client.screen.button.PlayerInventoryTabButton;
import net.dries007.tfc.common.container.TFCContainerProviders;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.network.PacketHandler;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public record SwitchInventoryTabPacket(PlayerInventoryTabButton.Tab tab) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SwitchInventoryTabPacket> TYPE = PacketHandler.type("switch_inventory_tab");
    public static final StreamCodec<ByteBuf, SwitchInventoryTabPacket> CODEC = PlayerInventoryTabButton.Tab.STREAM.map(SwitchInventoryTabPacket::new, c -> c.tab);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    void handle(@Nullable ServerPlayer player) {
        if (player != null) {
            player.doCloseContainer();
            switch (this.tab) {
                case INVENTORY: {
                    player.containerMenu = player.inventoryMenu;
                    break;
                }
                case CALENDAR: {
                    player.openMenu(TFCContainerProviders.CALENDAR);
                    break;
                }
                case NUTRITION: {
                    player.openMenu(TFCContainerProviders.NUTRITION);
                    break;
                }
                case CLIMATE: {
                    player.openMenu(TFCContainerProviders.CLIMATE);
                    break;
                }
                case BOOK: {
                    PatchouliIntegration.openGui(player);
                }
            }
        }
    }
}

