/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.dries007.tfc.common.component.fluid.FluidContainerInfo;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.common.recipes.AlloyRecipe;
import net.dries007.tfc.util.AlloyRange;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public final class FluidAlloy {
    public static final int MAX_ALLOY = 0x7FFFFFFD;
    public static final double EPSILON = 4.656612875245797E-10;
    public static final Codec<FluidAlloy> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("amount").forGetter(c -> c.amount), (App)Codec.unboundedMap((Codec)BuiltInRegistries.FLUID.byNameCodec(), (Codec)Codec.DOUBLE).xmap(Object2DoubleOpenHashMap::new, e -> e).fieldOf("content").forGetter(c -> c.content)).apply((Applicative)i, FluidAlloy::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidAlloy> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, c -> c.amount, (StreamCodec)ByteBufCodecs.map(Object2DoubleOpenHashMap::new, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.FLUID), (StreamCodec)ByteBufCodecs.DOUBLE), c -> c.content, FluidAlloy::new);
    private Object2DoubleMap<Fluid> content;
    private int amount;
    @Nullable
    private Object2DoubleMap<Fluid> cachedContent = null;
    @Nullable
    private FluidStack cachedResult = null;

    public static FluidAlloy empty() {
        return new FluidAlloy(0, (Object2DoubleMap<Fluid>)new Object2DoubleOpenHashMap());
    }

    private FluidAlloy(int amount, Object2DoubleMap<Fluid> content) {
        this.amount = amount;
        this.content = content;
    }

    public void copyFrom(FluidAlloy alloy) {
        this.amount = alloy.amount;
        this.content = alloy.content;
        this.cachedContent = alloy.cachedContent;
        this.cachedResult = alloy.cachedResult;
    }

    public FluidAlloy copy() {
        return new FluidAlloy(this.amount, (Object2DoubleMap<Fluid>)new Object2DoubleOpenHashMap(this.content));
    }

    public int fill(FluidStack fluid, IFluidHandler.FluidAction action, FluidContainerInfo info) {
        if (!info.canContainFluid(fluid)) {
            return 0;
        }
        int amount = fluid.getAmount();
        if (this.amount + amount >= info.fluidCapacity() && (amount = info.fluidCapacity() - this.amount) <= 0) {
            return 0;
        }
        if (action.execute()) {
            this.content.mergeDouble((Object)fluid.getFluid(), (double)amount, Double::sum);
            this.amount += amount;
            this.clearCaches();
        }
        return amount;
    }

    public FluidStack drain(int removeAmount, IFluidHandler.FluidAction action) {
        return this.drain(Helpers.getUnsafeRecipeManager(), removeAmount, action);
    }

    public FluidStack drain(Level level, int removeAmount, IFluidHandler.FluidAction action) {
        return this.drain(level.getRecipeManager(), removeAmount, action);
    }

    private FluidStack drain(RecipeManager recipes, int removeAmount, IFluidHandler.FluidAction action) {
        FluidStack result = this.getResult(recipes);
        if (action.simulate()) {
            return result.copyWithAmount(Math.min(this.amount, removeAmount));
        }
        if (removeAmount >= this.amount) {
            int total = this.amount;
            this.clear();
            return result.copyWithAmount(total);
        }
        Object2DoubleOpenHashMap newContent = new Object2DoubleOpenHashMap(this.content.size());
        for (Object2DoubleMap.Entry entry : this.content.object2DoubleEntrySet()) {
            double remove = (double)removeAmount * entry.getDoubleValue() / (double)this.amount;
            if (!(entry.getDoubleValue() > remove)) continue;
            newContent.put((Object)((Fluid)entry.getKey()), entry.getDoubleValue() - remove);
        }
        this.amount -= removeAmount;
        this.content = newContent;
        this.clearCaches();
        return result.copyWithAmount(removeAmount);
    }

    public FluidStack getResult() {
        return this.getResult(Helpers.getUnsafeRecipeManager());
    }

    public FluidStack getResult(Level level) {
        return this.getResult(level.getRecipeManager());
    }

    private FluidStack getResult(RecipeManager recipes) {
        if (this.cachedResult == null) {
            this.cachedResult = new FluidStack(switch (this.content.size()) {
                case 0 -> Fluids.EMPTY;
                case 1 -> (Fluid)this.content.keySet().iterator().next();
                default -> {
                    @Nullable AlloyRecipe recipe = AlloyRecipe.get(recipes, this);
                    if (recipe != null) {
                        yield recipe.result();
                    }
                    yield TFCFluids.METALS.get(Metal.UNKNOWN).getSource();
                }
            }, this.amount);
        }
        return this.cachedResult;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isEmpty() {
        return this.amount == 0;
    }

    public Object2DoubleMap<Fluid> getContent() {
        if (this.cachedContent == null) {
            double actualTotalAmount = this.getExactAmount();
            this.cachedContent = new Object2DoubleOpenHashMap(this.content.size());
            for (Object2DoubleMap.Entry entry : this.content.object2DoubleEntrySet()) {
                if (!(entry.getDoubleValue() > actualTotalAmount * 4.656612875245797E-10)) continue;
                this.cachedContent.put((Object)((Fluid)entry.getKey()), entry.getDoubleValue());
            }
        }
        return this.cachedContent;
    }

    public Tag serializeNBT() {
        return (Tag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).getOrThrow();
    }

    public void deserializeNBT(CompoundTag nbt) {
        FluidAlloy other = (FluidAlloy)((Pair)CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)nbt).getOrThrow()).getFirst();
        this.amount = other.amount;
        this.content = other.content;
        this.clearCaches();
    }

    public boolean matches(AlloyRecipe recipe) {
        if (this.content.containsKey((Object)recipe.result())) {
            FluidAlloy other = this.copy();
            other.content.removeDouble((Object)recipe.result());
            other.clearCaches();
            return other.matchesExactly(recipe);
        }
        return this.matchesExactly(recipe);
    }

    private void clear() {
        this.content.clear();
        this.amount = 0;
        this.clearCaches();
    }

    private void clearCaches() {
        this.cachedResult = null;
        this.cachedContent = null;
    }

    private double getExactAmount() {
        return this.content.values().doubleStream().sum();
    }

    private boolean matchesExactly(AlloyRecipe recipe) {
        Object2DoubleMap<Fluid> content = this.getContent();
        List<AlloyRange> requirements = recipe.contents();
        double actualTotalAmount = this.getExactAmount();
        HashSet inputsNotMatched = new HashSet(content.keySet());
        for (AlloyRange range : requirements) {
            Fluid fluid = range.fluid();
            if (!content.containsKey((Object)fluid) || !range.isIn(content.getDouble((Object)fluid) / actualTotalAmount)) {
                return false;
            }
            inputsNotMatched.remove(fluid);
        }
        return inputsNotMatched.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof FluidAlloy)) return false;
        FluidAlloy that = (FluidAlloy)obj;
        if (this.amount != that.amount) return false;
        if (!this.getContent().equals(that.getContent())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.getContent());
    }

    public String toString() {
        return "Alloy[%s mb of %s]".formatted(this.amount, this.getContent().object2DoubleEntrySet().stream().map(e -> "%.2f %s".formatted(e.getDoubleValue(), BuiltInRegistries.FLUID.getKey((Object)((Fluid)e.getKey())))).collect(Collectors.joining(", ")));
    }
}

