/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PowderKegExplosion
extends Explosion {
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity source;
    private final float size;

    public PowderKegExplosion(Level level, @Nullable Entity entity, double x, double y, double z, float size) {
        super(level, null, x, y, z, size, false, Explosion.BlockInteraction.DESTROY);
        this.level = level;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.source = entity;
    }

    public void finalizeExplosion(boolean spawnParticles) {
        assert (!this.level.isClientSide);
        List affectedBlockPositions = this.getToBlow();
        ObjectArrayList allDrops = new ObjectArrayList();
        Collections.shuffle(affectedBlockPositions, new Random());
        boolean easyMode = TFCConfig.SERVER.powderKegOnlyBreaksNaturalBlocks.get();
        for (BlockPos pos : affectedBlockPositions) {
            BlockState state = this.level.getBlockState(pos);
            if ((easyMode ? !Helpers.isBlock(state, TFCTags.Blocks.POWDERKEG_CAN_BREAK) : Helpers.isBlock(state, TFCTags.Blocks.POWDERKEG_CANNOT_BREAK)) || state.isAir()) continue;
            BlockPos dropPos = pos.immutable();
            this.level.getProfiler().push("explosion_blocks");
            if (state.canDropFromExplosion((BlockGetter)this.level, pos, (Explosion)this) && this.level instanceof ServerLevel) {
                BlockEntity blockentity = state.hasBlockEntity() ? this.level.getBlockEntity(pos) : null;
                LootParams.Builder lootContext = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)blockentity).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)this.source);
                state.getDrops(lootContext).forEach(drop -> PowderKegExplosion.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)allDrops, drop, dropPos));
            }
            state.onBlockExploded(this.level, pos, (Explosion)this);
            this.level.getProfiler().pop();
        }
        for (Pair pair : allDrops) {
            Block.popResource((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    private static void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> allDrops, ItemStack drop, BlockPos dropPos) {
        int i = allDrops.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)allDrops.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.areMergable((ItemStack)itemstack, (ItemStack)drop)) continue;
            ItemStack itemstack1 = ItemEntity.merge((ItemStack)itemstack, (ItemStack)drop, (int)16);
            allDrops.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!drop.isEmpty()) continue;
            return;
        }
        allDrops.add((Object)Pair.of((Object)drop, (Object)dropPos));
    }

    public void sendExplosionPacketToClients() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer serverplayer : serverLevel.players()) {
                if (!(serverplayer.distanceToSqr(this.x, this.y, this.z) < 4096.0)) continue;
                serverplayer.connection.send((Packet)new ClientboundExplodePacket(this.x, this.y, this.z, this.size, this.getToBlow(), (Vec3)this.getHitPlayers().get(serverplayer), this.getBlockInteraction(), this.getSmallExplosionParticles(), this.getLargeExplosionParticles(), this.getExplosionSound()));
            }
        }
    }
}

