/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import java.time.LocalDate;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.mixin.accessor.GameRulesAccessor;
import net.dries007.tfc.mixin.accessor.GameRulesTypeAccessor;
import net.dries007.tfc.network.CalendarUpdatePacket;
import net.dries007.tfc.util.ReentrantListener;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.dries007.tfc.util.calendar.Calendar;
import net.dries007.tfc.util.calendar.CalendarWorldData;
import net.minecraft.gametest.framework.GameTestServer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.GameRules;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public final class ServerCalendar
extends Calendar {
    public static final int SYNC_INTERVAL = 20;
    private static final ReentrantListener DO_DAYLIGHT_CYCLE = new ReentrantListener(ServerCalendar::overrideDoDaylightCycleToFalse);
    private int syncCounter;

    private static void overrideDoDaylightCycleToFalse() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ((GameRules.BooleanValue)server.getGameRules().getRule(GameRules.RULE_DAYLIGHT)).set(false, server);
    }

    public static void overrideDoDaylightCycleCallback() {
        GameRulesTypeAccessor type = (GameRulesTypeAccessor)GameRulesAccessor.accessor$getGameRuleTypes().get(GameRules.RULE_DAYLIGHT);
        type.accessor$setCallback(type.accessor$getCallback().andThen((server, t) -> DO_DAYLIGHT_CYCLE.onListenerUpdate()));
    }

    public void skipForwardBy(long calendarTicks) {
        this.calendarTicks += calendarTicks;
        this.playerTicks = (long)((float)this.playerTicks + (this.calendarTickRate == 0.0f ? 0.0f : (float)calendarTicks / this.calendarTickRate));
        this.updateDayTime(this.getServer().overworld());
        this.sendUpdatePacket();
    }

    public void setMonthLength(int newMonthLength) {
        long baseMonths = this.calendarTicks / this.getCalendarTicksInMonth();
        double baseFractionOfMonth = this.getCalendarFractionOfMonth();
        long baseDayTime = this.calendarTicks % 24000L;
        this.daysInMonth = newMonthLength;
        this.calendarTicks = baseMonths * (long)this.daysInMonth * 24000L + (long)(baseFractionOfMonth * (double)this.daysInMonth) * 1000L + baseDayTime;
        this.updateDayTime(this.getServer().overworld());
        this.sendUpdatePacket();
    }

    public void setCalendarTickRate(float calendarTickRate) {
        this.calendarTickRate = calendarTickRate;
        this.sendUpdatePacket();
    }

    public void setPlayersLoggedOn(boolean arePlayersLoggedOn) {
        boolean alwaysRunAsIfPlayersAreLoggedIn = TFCConfig.SERVER.enableTimeStopWhenServerEmpty.get() == false;
        this.arePlayersLoggedOn = arePlayersLoggedOn || alwaysRunAsIfPlayersAreLoggedIn;
        this.sendUpdatePacket();
    }

    void onServerStart(MinecraftServer server) {
        this.resetTo(CalendarWorldData.get(server.overworld()).getCalendar());
        this.sendUpdatePacket();
        if (server instanceof GameTestServer) {
            this.setPlayersLoggedOn(true);
        }
    }

    void onServerStop() {
        this.resetToDefault();
    }

    void onServerTick() {
        if (!this.getServer().tickRateManager().isFrozen() && this.arePlayersLoggedOn) {
            ++this.playerTicks;
        }
        ++this.syncCounter;
        if (this.syncCounter >= 20) {
            this.sendUpdatePacket();
            this.syncCounter = 0;
        }
    }

    void onOverworldTick(ServerLevel level) {
        if (!this.getServer().tickRateManager().isFrozen() && this.arePlayersLoggedOn) {
            this.advanceCalendarTick();
            if ((this.calendarTicks & 0x100L) == 0L) {
                this.checkIfInTheFuture(level);
            }
        }
        this.updateDayTime(level);
    }

    void checkIfInTheFuture(ServerLevel level) {
        LocalDate calendarDate;
        LocalDate date = LocalDate.now();
        if (date.isBefore(calendarDate = LocalDate.of(Mth.clamp((int)((int)this.getCalendarYear()), (int)-999999999, (int)999999999), this.getAbsoluteCalendarMonthOfYear().ordinal() + 1, Mth.clamp((int)this.getCalendarDayOfMonth(), (int)1, (int)28)))) {
            level.getServer().getPlayerList().getPlayers().forEach(TFCAdvancements.PRESENT_DAY::trigger);
        }
    }

    void sendUpdatePacket() {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new CalendarUpdatePacket(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    void updateDayTime(ServerLevel level) {
        level.setDayTime(this.calendarTicks + 18000L);
    }

    private MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }
}

