/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import java.util.Locale;
import net.minecraft.util.StringRepresentable;

public enum KoppenClimateClassification implements StringRepresentable
{
    AF,
    AM,
    AW,
    AS,
    BWH,
    BWK,
    BSH,
    BSK,
    CSA,
    CSB,
    CSC,
    CWA,
    CWB,
    CWC,
    CFA,
    CFB,
    CFC,
    DSA,
    DSB,
    DSC,
    DSD,
    DWA,
    DWB,
    DWC,
    DWD,
    DFA,
    DFB,
    DFC,
    DFD,
    ET,
    EF;

    private final String name = this.name().toLowerCase(Locale.ROOT);

    public static KoppenClimateClassification classify(float averageTemperature, float rainfall, float rainVar, boolean isInNorthernHemisphere) {
        if (!isInNorthernHemisphere) {
            rainVar = -rainVar;
        }
        if ((double)averageTemperature < -17.0 + 0.006 * (double)rainfall) {
            return EF;
        }
        if (averageTemperature <= -12.0f) {
            return ET;
        }
        if (rainfall < 75.0f) {
            if (averageTemperature > 18.0f) {
                return BWH;
            }
            return BWK;
        }
        if (rainfall < 150.0f) {
            if (averageTemperature > 18.0f) {
                return BSH;
            }
            return BSK;
        }
        if (averageTemperature > 21.0f) {
            if (rainfall * (1.0f + rainVar) > 600.0f) {
                return AM;
            }
            if (rainVar > 0.5f) {
                return AW;
            }
            if (rainVar < -0.5f) {
                return AS;
            }
            return AF;
        }
        if (averageTemperature > 8.0f) {
            if (averageTemperature > 17.0f) {
                if (rainVar > 0.5f) {
                    return CWA;
                }
                if (rainVar < -0.5f) {
                    return CSA;
                }
                return CFA;
            }
            if (averageTemperature > 12.0f) {
                if (rainVar > 0.5f) {
                    return CWB;
                }
                if (rainVar < -0.5f) {
                    return CSB;
                }
                return CFB;
            }
            if (rainVar > 0.5f) {
                return CWC;
            }
            if (rainVar < -0.5f) {
                return CSC;
            }
            return CFC;
        }
        if (averageTemperature > 3.0f) {
            if (rainVar > 0.5f) {
                return DWA;
            }
            if (rainVar < -0.5f) {
                return DSA;
            }
            return DFA;
        }
        if (averageTemperature > -2.0f) {
            if (rainVar > 0.5f) {
                return DWB;
            }
            if (rainVar < -0.5f) {
                return DSB;
            }
            return DFB;
        }
        if (averageTemperature > -8.0f) {
            if (rainVar > 0.5f) {
                return DWC;
            }
            if (rainVar < -0.5f) {
                return DSC;
            }
            return DFC;
        }
        if (rainVar > 0.5f) {
            return DWD;
        }
        if (rainVar < -0.5f) {
            return DSD;
        }
        return DFD;
    }

    public String getSerializedName() {
        return this.name;
    }
}

