/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.dries007.tfc.util.SelfTests;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class DataManager<T>
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private final String registryName;
    private final Codec<T> codec;
    @Nullable
    private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;
    private Map<ResourceLocation, T> byKey = Map.of();
    private Map<T, ResourceLocation> toKey = Map.of();
    private final Codec<Reference<T>> byIdCodec = ResourceLocation.CODEC.xmap(this::getReference, Reference::id);
    private final StreamCodec<ByteBuf, Reference<T>> byIdStreamCodec = ResourceLocation.STREAM_CODEC.map(this::getReference, Reference::id);
    private final Map<ResourceLocation, Reference<T>> references = new HashMap<ResourceLocation, Reference<T>>();
    private final Object referencesLock = new Object();

    public DataManager(ResourceLocation domain, Codec<T> codec) {
        this(domain, codec, null);
    }

    public DataManager(ResourceLocation domain, Codec<T> codec, @Nullable StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) {
        super(GSON, domain.getNamespace() + "/" + domain.getPath());
        this.registryName = domain.getPath();
        this.codec = codec;
        this.streamCodec = streamCodec;
    }

    @Nullable
    public T get(ResourceLocation id) {
        return this.byKey.get(id);
    }

    @Nullable
    public ResourceLocation getId(T value) {
        return this.toKey.get(value);
    }

    public T getOrThrow(ResourceLocation id) {
        return Objects.requireNonNull(this.byKey.get(id));
    }

    public ResourceLocation getIdOrThrow(T value) {
        return Objects.requireNonNull(this.toKey.get(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<T> getReference(ResourceLocation id) {
        Reference ref;
        Object object = this.referencesLock;
        synchronized (object) {
            ref = this.references.computeIfAbsent(id, key -> new Reference<T>((ResourceLocation)key, this.byKey.get(key)));
        }
        return ref;
    }

    public Reference<T> getCheckedReference(ResourceLocation id) {
        return this.references.computeIfAbsent(id, key -> new Reference<T>((ResourceLocation)key, this.getOrThrow(id)));
    }

    public Map<ResourceLocation, T> getElements() {
        return this.byKey;
    }

    public Collection<T> getValues() {
        return this.byKey.values();
    }

    public boolean isSynced() {
        return this.streamCodec != null;
    }

    public final Codec<Reference<T>> byIdReferenceCodec() {
        return this.byIdCodec;
    }

    public final StreamCodec<ByteBuf, Reference<T>> byIdStreamCodec() {
        return this.byIdStreamCodec;
    }

    public final Codec<T> codec() {
        return this.codec;
    }

    public final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return Objects.requireNonNull(this.streamCodec);
    }

    public void bindValues(Map<ResourceLocation, T> elements) {
        this.byKey = ImmutableMap.copyOf(elements);
        this.updateReferences();
        LOGGER.info("Received {} {}(s) from physical server", (Object)this.byKey.size(), (Object)this.registryName);
    }

    public final String getName() {
        return this.registryName;
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        RegistryOps ops = this.getRegistryLookup().createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        for (Map.Entry<ResourceLocation, JsonElement> entry : elements.entrySet()) {
            ResourceLocation id = entry.getKey();
            try {
                builder.put((Object)id, this.codec.parse((DynamicOps)ops, (Object)entry.getValue()).getOrThrow(JsonParseException::new));
            }
            catch (JsonParseException | IllegalArgumentException e) {
                LOGGER.error("{} '{}' failed to parse. {}: {}", new Object[]{this.registryName, id, e.getClass().getSimpleName(), e.getMessage()});
                SelfTests.reportExternalError();
            }
        }
        this.byKey = builder.build();
        this.updateReferences();
        LOGGER.info("Loaded {} {}(s).", (Object)this.byKey.size(), (Object)this.registryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReferences() {
        Object object = this.referencesLock;
        synchronized (object) {
            ArrayList<ResourceLocation> unboundReferences = new ArrayList<ResourceLocation>();
            for (Map.Entry<ResourceLocation, Reference<T>> entry : this.references.entrySet()) {
                T value2 = this.get(entry.getKey());
                if (value2 == null) {
                    unboundReferences.add(entry.getKey());
                }
                entry.getValue().value = Optional.ofNullable(value2);
            }
            if (!unboundReferences.isEmpty()) {
                LOGGER.error("There were {} '{}' that were used but not defined: {}", new Object[]{unboundReferences.size(), this.registryName, unboundReferences});
                SelfTests.reportExternalError();
            }
        }
        this.toKey = new IdentityHashMap<T, ResourceLocation>();
        this.byKey.forEach((id, value) -> this.toKey.put((T)value, (ResourceLocation)id));
        this.toKey = Collections.unmodifiableMap(this.toKey);
    }

    public static class Reference<T>
    implements Supplier<T> {
        private final ResourceLocation id;
        private Optional<T> value;

        Reference(ResourceLocation id, @Nullable T value) {
            this.id = id;
            this.value = Optional.ofNullable(value);
        }

        public ResourceLocation id() {
            return this.id;
        }

        @Override
        public T get() {
            return this.value.orElseThrow(() -> new IllegalStateException("Referencing value before loaded"));
        }

        public void set(T value) {
            assert (this.value.isEmpty()) : "Assigned a duplicate value!";
            this.value = Optional.of(value);
        }
    }
}

