/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.data;

import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.size.ItemSizeManager;
import net.dries007.tfc.common.entities.Fauna;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.data.DataManager;
import net.dries007.tfc.util.data.Deposit;
import net.dries007.tfc.util.data.Drinkable;
import net.dries007.tfc.util.data.EntityDamageResistance;
import net.dries007.tfc.util.data.Fertilizer;
import net.dries007.tfc.util.data.FluidHeat;
import net.dries007.tfc.util.data.Fuel;
import net.dries007.tfc.util.data.ItemDamageResistance;
import net.dries007.tfc.util.data.KnappingType;
import net.dries007.tfc.util.data.LampFuel;
import net.dries007.tfc.util.data.Support;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;

public final class DataManagers {
    public static final ResourceKey<Registry<DataManager<?>>> KEY = ResourceKey.createRegistryKey((ResourceLocation)Helpers.identifier("data_manager"));
    public static final Registry<DataManager<?>> REGISTRY = new RegistryBuilder(KEY).sync(true).create();
    public static final DeferredRegister<DataManager<?>> MANAGERS = DeferredRegister.create(KEY, (String)"tfc");

    private static void register(DataManager<?> manager) {
        MANAGERS.register(manager.getName(), () -> manager);
    }

    static {
        DataManagers.register(EntityDamageResistance.MANAGER);
        DataManagers.register(ItemDamageResistance.MANAGER);
        DataManagers.register(Drinkable.MANAGER);
        DataManagers.register(Fertilizer.MANAGER);
        DataManagers.register(Fuel.MANAGER);
        DataManagers.register(FluidHeat.MANAGER);
        DataManagers.register(KnappingType.MANAGER);
        DataManagers.register(Support.MANAGER);
        DataManagers.register(ItemSizeManager.MANAGER);
        DataManagers.register(Fauna.MANAGER);
        DataManagers.register(ClimateRange.MANAGER);
        DataManagers.register(LampFuel.MANAGER);
        DataManagers.register(Deposit.MANAGER);
        DataManagers.register(HeatCapability.MANAGER);
        DataManagers.register(FoodCapability.MANAGER);
    }
}

