/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.network.StreamCodecs;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.data.DataManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

public record KnappingType(SizedIngredient inputItem, int amountToConsume, Holder<SoundEvent> clickSound, boolean consumeAfterComplete, boolean hasOffTexture, boolean spawnsParticles, ItemStack icon) implements IRecipePredicate<ItemStack>
{
    public static final Codec<KnappingType> CODEC = RecordCodecBuilder.create(i -> i.group((App)SizedIngredient.FLAT_CODEC.fieldOf("input").forGetter(c -> c.inputItem), (App)Codec.INT.optionalFieldOf("amount_to_consume").forGetter(c -> c.amountToConsume == c.inputItem.count() ? Optional.empty() : Optional.of(c.amountToConsume)), (App)SoundEvent.CODEC.fieldOf("click_sound").forGetter(c -> c.clickSound), (App)Codec.BOOL.fieldOf("consume_after_complete").forGetter(c -> c.consumeAfterComplete), (App)Codec.BOOL.fieldOf("has_off_texture").forGetter(c -> c.hasOffTexture), (App)Codec.BOOL.fieldOf("spawns_particles").forGetter(c -> c.spawnsParticles), (App)ItemStack.CODEC.fieldOf("icon").forGetter(c -> c.icon)).apply((Applicative)i, KnappingType::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, KnappingType> STREAM_CODEC = StreamCodecs.composite(SizedIngredient.STREAM_CODEC, c -> c.inputItem, ByteBufCodecs.VAR_INT, c -> c.amountToConsume, ByteBufCodecs.holderRegistry((ResourceKey)Registries.SOUND_EVENT), c -> c.clickSound, ByteBufCodecs.BOOL, c -> c.consumeAfterComplete, ByteBufCodecs.BOOL, c -> c.hasOffTexture, ByteBufCodecs.BOOL, c -> c.spawnsParticles, ItemStack.STREAM_CODEC, c -> c.icon, KnappingType::new);
    public static final DataManager<KnappingType> MANAGER = new DataManager<KnappingType>(Helpers.identifier("knapping_type"), CODEC, STREAM_CODEC);

    public KnappingType(SizedIngredient inputItem, Optional<Integer> amountToConsume, Holder<SoundEvent> clickSound, boolean consumeAfterComplete, boolean useDisabledTexture, boolean spawnsParticles, ItemStack jeiIconItem) {
        this(inputItem, amountToConsume.orElse(inputItem.count()), clickSound, consumeAfterComplete, useDisabledTexture, spawnsParticles, jeiIconItem);
    }

    @Nullable
    public static KnappingType get(ItemStack stack) {
        return RecipeHelpers.getRecipe(MANAGER.getValues(), stack);
    }

    @Override
    public boolean matches(ItemStack input) {
        return this.inputItem.test(input);
    }
}

