/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Set;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.dries007.tfc.util.data.DataManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public record Support(BlockIngredient ingredient, int supportUp, int supportDown, int supportHorizontal) {
    public static final Codec<Support> CODEC = RecordCodecBuilder.create(i -> i.group((App)BlockIngredient.CODEC.fieldOf("ingredient").forGetter(c -> c.ingredient), (App)Codec.INT.fieldOf("support_up").forGetter(c -> c.supportUp), (App)Codec.INT.fieldOf("support_down").forGetter(c -> c.supportDown), (App)Codec.INT.fieldOf("support_horizontal").forGetter(c -> c.supportHorizontal)).apply((Applicative)i, Support::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Support> STREAM_CODEC = StreamCodec.composite(BlockIngredient.STREAM_CODEC, c -> c.ingredient, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.supportUp, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.supportDown, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.supportHorizontal, Support::new);
    public static final DataManager<Support> MANAGER = new DataManager<Support>(Helpers.identifier("support"), CODEC, STREAM_CODEC);
    public static final IndirectHashCollection<Block, Support> CACHE = IndirectHashCollection.create(s -> s.ingredient.blocks(), MANAGER::getValues);
    private static SupportRange RANGE = new SupportRange(0, 0, 0);

    public static SupportRange getSupportCheckRange() {
        return RANGE;
    }

    public static Set<BlockPos> findUnsupportedPositions(BlockGetter worldIn, BlockPos from, BlockPos to) {
        HashSet<BlockPos> listSupported = new HashSet<BlockPos>();
        HashSet<BlockPos> listUnsupported = new HashSet<BlockPos>();
        int minX = Math.min(from.getX(), to.getX());
        int maxX = Math.max(from.getX(), to.getX());
        int minY = Math.min(from.getY(), to.getY());
        int maxY = Math.max(from.getY(), to.getY());
        int minZ = Math.min(from.getZ(), to.getZ());
        int maxZ = Math.max(from.getZ(), to.getZ());
        for (BlockPos searchingPoint : Support.getMaximumSupportedAreaAround(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ))) {
            BlockState supportState;
            Support support;
            if (!listSupported.contains(searchingPoint)) {
                listUnsupported.add(searchingPoint.immutable());
            }
            if ((support = Support.get(supportState = worldIn.getBlockState(searchingPoint))) == null) continue;
            for (BlockPos supported : support.getSupportedArea(searchingPoint)) {
                listSupported.add(supported.immutable());
                listUnsupported.remove(supported);
            }
        }
        listUnsupported.removeIf(content -> content.getX() < minX || content.getX() > maxX || content.getY() < minY || content.getY() > maxY || content.getZ() < minZ || content.getZ() > maxZ);
        return listUnsupported;
    }

    public static boolean isSupported(BlockGetter world, BlockPos pos) {
        for (BlockPos supportPos : Support.getMaximumSupportedAreaAround(pos, pos)) {
            BlockState supportState = world.getBlockState(supportPos);
            Support support = Support.get(supportState);
            if (support == null || !support.canSupport(supportPos, pos)) continue;
            return true;
        }
        return false;
    }

    public static Iterable<BlockPos> getMaximumSupportedAreaAround(BlockPos minPoint, BlockPos maxPoint) {
        return BlockPos.betweenClosed((BlockPos)minPoint.offset(-RANGE.horizontal(), -RANGE.down(), -RANGE.horizontal()), (BlockPos)maxPoint.offset(RANGE.horizontal(), RANGE.up(), RANGE.horizontal()));
    }

    @Nullable
    public static Support get(BlockState state) {
        for (Support support : CACHE.getAll(state.getBlock())) {
            if (!support.ingredient.test(state)) continue;
            return support;
        }
        return null;
    }

    public static void updateMaximumSupportRange() {
        int up = 0;
        int down = 0;
        int horizontal = 0;
        for (Support support : MANAGER.getValues()) {
            up = Math.max(support.supportUp(), up);
            down = Math.max(support.supportDown(), down);
            horizontal = Math.max(support.supportHorizontal(), horizontal);
        }
        RANGE = new SupportRange(up, down, horizontal);
    }

    public boolean canSupport(BlockPos supportPos, BlockPos testPos) {
        BlockPos diff = supportPos.subtract((Vec3i)testPos);
        return Math.abs(diff.getX()) <= this.supportHorizontal && -this.supportDown <= diff.getY() && diff.getY() <= this.supportUp && Math.abs(diff.getZ()) <= this.supportHorizontal;
    }

    public Iterable<BlockPos> getSupportedArea(BlockPos center) {
        return BlockPos.betweenClosed((BlockPos)center.offset(-this.supportHorizontal, -this.supportDown, -this.supportHorizontal), (BlockPos)center.offset(this.supportHorizontal, this.supportUp, this.supportHorizontal));
    }

    public record SupportRange(int up, int down, int horizontal) {
    }
}

