/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.events;

import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public final class StartFireEvent
extends Event
implements ICancellableEvent {
    private final Level world;
    private final BlockPos pos;
    private final BlockState state;
    private final Direction direction;
    @Nullable
    private final Player player;
    private final ItemStack stack;
    private final FireStrength strength;

    public static boolean startFireWithSound(Level level, BlockPos pos, BlockState state, Direction direction, @Nullable Player player, ItemStack stack) {
        boolean startFire = StartFireEvent.startFire(level, pos, state, direction, player, stack, FireStrength.STRONG, 1.0);
        if (startFire) {
            if (stack.getItem() instanceof FlintAndSteelItem) {
                level.playSound(player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            } else if (stack.getItem() instanceof FireChargeItem) {
                level.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 1.0f, (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2f + 1.0f);
            }
        }
        return startFire;
    }

    public static boolean startFire(Level level, BlockPos pos, BlockState state, Direction direction, @Nullable Player player, ItemStack stack) {
        return StartFireEvent.startFire(level, pos, state, direction, player, stack, FireStrength.STRONG, 1.0);
    }

    public static boolean startFire(Level level, BlockPos pos, BlockState state, Direction direction, @Nullable Player player, ItemStack stack, FireStrength strength, double firepitBaseChance) {
        StartFireEvent event = new StartFireEvent(level, pos, state, direction, player, stack, strength);
        boolean cancelled = ((StartFireEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
        if (cancelled && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TFCAdvancements.LIT.trigger(serverPlayer, state);
        }
        if (!cancelled && event.isStrong()) {
            BlockPos abovePos = pos.above();
            if (FirepitBlock.canSurvive((LevelReader)level, abovePos) && firepitBaseChance != -1.0) {
                List items = level.getEntitiesOfClass(ItemEntity.class, new AABB((double)abovePos.getX() - 0.5, (double)abovePos.getY(), (double)abovePos.getZ() - 0.5, (double)abovePos.getX() + 1.5, (double)(abovePos.getY() + 1), (double)abovePos.getZ() + 1.5));
                ArrayList<ItemEntity> usableItems = new ArrayList<ItemEntity>();
                int sticks = 0;
                int kindling = 0;
                ItemEntity logEntity = null;
                for (ItemEntity entity : items) {
                    ItemStack foundStack = entity.getItem();
                    Item foundItem = foundStack.getItem();
                    int itemCount = foundStack.getCount();
                    if (Helpers.isItem(foundItem, TFCTags.Items.FIREPIT_STICKS)) {
                        sticks += itemCount;
                        usableItems.add(entity);
                        continue;
                    }
                    if (Helpers.isItem(foundItem, TFCTags.Items.FIREPIT_KINDLING)) {
                        kindling += itemCount;
                        usableItems.add(entity);
                        continue;
                    }
                    if (logEntity != null || !Helpers.isItem(foundItem, TFCTags.Items.FIREPIT_LOGS)) continue;
                    logEntity = entity;
                }
                if (sticks >= 3 && logEntity != null) {
                    float kindlingModifier = Math.min(0.1f * (float)kindling, 0.5f);
                    if ((double)level.random.nextFloat() < firepitBaseChance + (double)kindlingModifier) {
                        usableItems.forEach(Entity::kill);
                        logEntity.kill();
                        ItemStack initialLog = logEntity.getItem().copy();
                        initialLog.setCount(1);
                        BlockState firepitState = player != null ? (BlockState)((Block)TFCBlocks.FIREPIT.get()).defaultBlockState().setValue(FirepitBlock.AXIS, (Comparable)player.getDirection().getAxis()) : (BlockState)((Block)TFCBlocks.FIREPIT.get()).defaultBlockState().setValue(FirepitBlock.AXIS, (Comparable)Direction.Axis.X);
                        level.setBlock(abovePos, firepitState, 3);
                        level.getBlockEntity(abovePos, (BlockEntityType)TFCBlockEntities.FIREPIT.get()).ifPresent(firepit -> {
                            ((ItemStackHandler)firepit.getInventory()).setStackInSlot(0, initialLog);
                            firepit.light(firepitState);
                        });
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            TFCAdvancements.FIREPIT_CREATED.trigger(serverPlayer, firepitState);
                        }
                        return true;
                    }
                    return false;
                }
            }
            if (state.isCollisionShapeFullBlock((BlockGetter)level, pos)) {
                pos = pos.relative(direction);
            } else {
                BlockState stateAt = level.getBlockState(pos);
                if (stateAt.isFlammable((BlockGetter)level, pos, direction) && (stateAt.canBeReplaced() || stateAt.getCollisionShape((BlockGetter)level, pos).isEmpty())) {
                    level.destroyBlock(pos, false);
                }
            }
            if (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)pos, (Direction)direction)) {
                level.setBlock(pos, BaseFireBlock.getState((BlockGetter)level, (BlockPos)pos), 11);
                return true;
            }
        }
        return cancelled;
    }

    private StartFireEvent(Level world, BlockPos pos, BlockState state, Direction direction, @Nullable Player player, ItemStack stack, FireStrength strength) {
        this.world = world;
        this.pos = pos;
        this.state = state;
        this.direction = direction;
        this.player = player;
        this.stack = stack;
        this.strength = strength;
    }

    public Level getLevel() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getState() {
        return this.state;
    }

    public Direction getTargetedFace() {
        return this.direction;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public boolean isStrong() {
        return this.strength == FireStrength.STRONG;
    }

    public static enum FireStrength {
        STRONG,
        WEAK;

    }
}

