/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.loot;

import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.util.loot.MinMaxProvider;
import net.dries007.tfc.util.loot.TFCLoot;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class AnimalYieldProvider
extends MinMaxProvider {
    public AnimalYieldProvider(NumberProvider min, NumberProvider max) {
        super(min, max);
    }

    public float getFloat(LootContext context) {
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        Player player = (Player)context.getParamOrNull(LootContextParams.LAST_DAMAGE_PLAYER);
        if (entity instanceof TFCAnimalProperties) {
            float familiarity;
            TFCAnimalProperties properties = (TFCAnimalProperties)entity;
            float adjustedSize = properties.getGeneticSize();
            if (player != null) {
                adjustedSize = (float)((double)adjustedSize + Mth.clampedMap((double)player.getAttributeValue(Attributes.ATTACK_DAMAGE), (double)0.0, (double)16.0, (double)1.0, (double)8.0));
            }
            if ((familiarity = properties.getFamiliarity()) > 0.5f) {
                adjustedSize += Mth.clampedMap((float)familiarity, (float)0.5f, (float)1.0f, (float)1.0f, (float)8.0f);
            }
            float scaledSize = Mth.clampedMap((float)adjustedSize, (float)1.0f, (float)46.0f, (float)0.0f, (float)1.0f);
            return Mth.lerp((float)scaledSize, (float)this.min.getFloat(context), (float)this.max.getFloat(context));
        }
        return this.min.getFloat(context);
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)TFCLoot.ANIMAL_YIELD.get();
    }
}

