/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.registry;

import com.google.common.base.Suppliers;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.dries007.tfc.common.container.ItemStackContainerProvider;
import net.dries007.tfc.common.fluids.FluidHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public final class RegistrationHelpers {
    public static <T extends Block> DeferredHolder<Block, T> registerBlock(DeferredRegister<Block> blocks, DeferredRegister<Item> items, String name, Supplier<T> blockSupplier, @Nullable Function<T, ? extends BlockItem> blockItemFactory) {
        String actualName = name.toLowerCase(Locale.ROOT);
        DeferredHolder block = blocks.register(actualName, blockSupplier);
        if (blockItemFactory != null) {
            items.register(actualName, () -> (BlockItem)blockItemFactory.apply((Block)block.get()));
        }
        return block;
    }

    public static <F extends FlowingFluid> FluidHolder<F> registerFluid(DeferredRegister<FluidType> fluidTypes, DeferredRegister<Fluid> fluids, String typeName, String sourceName, String flowingName, Consumer<BaseFlowingFluid.Properties> builder, Supplier<FluidType> typeFactory, Function<BaseFlowingFluid.Properties, F> sourceFactory, Function<BaseFlowingFluid.Properties, F> flowingFactory) {
        MutableObject typeBox = new MutableObject();
        DeferredHolder source = fluids.register(sourceName, () -> RegistrationHelpers.lambda$registerFluid$1(sourceFactory, (Mutable)typeBox));
        DeferredHolder flowing = fluids.register(flowingName, () -> RegistrationHelpers.lambda$registerFluid$2(flowingFactory, (Mutable)typeBox));
        DeferredHolder fluidType = fluidTypes.register(typeName, typeFactory);
        typeBox.setValue((Object)Suppliers.memoize(() -> {
            BaseFlowingFluid.Properties lazyProperties = new BaseFlowingFluid.Properties((Supplier)fluidType, (Supplier)source, (Supplier)flowing);
            builder.accept(lazyProperties);
            return lazyProperties;
        }));
        return new FluidHolder((DeferredHolder<FluidType, FluidType>)fluidType, flowing, source);
    }

    public static <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> register(DeferredRegister<BlockEntityType<?>> blockEntities, String name, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<? extends Block> block) {
        return blockEntities.register(name, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)factory, (Block[])new Block[]{(Block)block.get()}).build(null));
    }

    public static <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> register(DeferredRegister<BlockEntityType<?>> blockEntities, String name, BlockEntityType.BlockEntitySupplier<T> factory, Stream<? extends Supplier<? extends Block>> blocks) {
        return blockEntities.register(name, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)factory, (Block[])((Block[])blocks.map(Supplier::get).toArray(Block[]::new))).build(null));
    }

    public static <T extends InventoryBlockEntity<?>, C extends BlockEntityContainer<T>> DeferredHolder<MenuType<?>, MenuType<C>> registerBlockEntityContainer(DeferredRegister<MenuType<?>> containers, String name, Supplier<BlockEntityType<T>> type, BlockEntityContainer.Factory<T, C> factory) {
        return RegistrationHelpers.registerContainer(containers, name, (windowId, playerInventory, buffer) -> {
            Level level = playerInventory.player.level();
            BlockPos pos = buffer.readBlockPos();
            InventoryBlockEntity entity = (InventoryBlockEntity)level.getBlockEntity(pos, (BlockEntityType)type.get()).orElseThrow();
            return factory.create(entity, playerInventory, windowId);
        });
    }

    public static <C extends ItemStackContainer> DeferredHolder<MenuType<?>, MenuType<C>> registerItemStackContainer(DeferredRegister<MenuType<?>> containers, String name, ItemStackContainer.Factory<C> factory) {
        return RegistrationHelpers.registerContainer(containers, name, (windowId, playerInventory, buffer) -> {
            ItemStackContainerProvider.Info info = ItemStackContainerProvider.read((FriendlyByteBuf)buffer, playerInventory);
            return factory.create(info.stack(), info.hand(), info.slot(), playerInventory, windowId);
        });
    }

    public static <C extends AbstractContainerMenu> DeferredHolder<MenuType<?>, MenuType<C>> registerContainer(DeferredRegister<MenuType<?>> containers, String name, IContainerFactory<C> factory) {
        return containers.register(name, () -> new MenuType((MenuType.MenuSupplier)factory, FeatureFlags.DEFAULT_FLAGS));
    }

    private static /* synthetic */ FlowingFluid lambda$registerFluid$2(Function flowingFactory, Mutable typeBox) {
        return (FlowingFluid)flowingFactory.apply((BaseFlowingFluid.Properties)((Supplier)typeBox.getValue()).get());
    }

    private static /* synthetic */ FlowingFluid lambda$registerFluid$1(Function sourceFactory, Mutable typeBox) {
        return (FlowingFluid)sourceFactory.apply((BaseFlowingFluid.Properties)((Supplier)typeBox.getValue()).get());
    }
}

